% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-group_by.R
\name{group_split}
\alias{group_split}
\alias{group_split.PlySummarizedExperiment}
\title{Split a PlySummarizedExperiment based on groups}
\usage{
\method{group_split}{PlySummarizedExperiment}(.tbl, ..., .keep = TRUE)
}
\arguments{
\item{.tbl}{a PlySummarizedExperiment object}

\item{...}{ignored if the \code{.tbl} is grouped, otherwise it is passed to
\link{group_by}.}

\item{.keep}{logical indicating of grouping variables should be kept}
}
\value{
A list of PlySummarizedExperiment objects
}
\description{
Splits a grouped PlySummarizedExperiment based on groups. Note the elements
of the return value are ungrouped PlySummarizedExperiment objects.
}
\examples{

gse <- group_by(se_simple, rows(direction), cols(condition))
gse |> group_split()
gse |> group_split(.keep = FALSE)

}
