% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-arrange.R
\name{arrange}
\alias{arrange}
\alias{arrange.PlySummarizedExperiment}
\title{arrange rows or columns of PlySummarizedExperiment}
\usage{
\method{arrange}{PlySummarizedExperiment}(.data, ..., .by_group = FALSE)
}
\arguments{
\item{.data}{An object Inheriting from \code{PlySummarizedExperiment}, the wrapper
class for \code{SummarizedExperiment} objects}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\value{
an object inheriting \code{PlySummarizedExperiment} class
}
\description{
\code{arrange()} orders either the rows or columns of a \code{PlySummarizedExperiment}
object. Note, to guarentee a valid \code{PlySummarizedExperiment} is returned,
arranging in the \code{assays} evaluation context is disabled.

Unlike other dplyr verbs, \code{arrange()} largely ignores grouping. The
\code{PlySummarizedExperiment} method also provides the same functionality via the
\code{.by_group} argument.
}
\examples{

# arrange within rows/cols contexts separately
arrange(
  se_simple,
  rows(direction),
  cols(dplyr::desc(condition))
)

# access assay data to compute arrangement
arrange(
  se_simple,
  rows(rowSums(.assays_asis$counts)),
  cols(colSums(.assays_asis$counts))
)

# assay context is disabled
arrange(se_simple, counts) |> try()

# convert to `data.frame` first
as.data.frame(se_simple) |>
  arrange(counts)

}
