% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-arithmetic-shift.R
\name{shift_left}
\alias{shift_left}
\alias{shift_right}
\alias{shift_upstream}
\alias{shift_downstream}
\title{Shift all coordinates in a genomic interval left or right, upstream or downstream}
\usage{
shift_left(x, shift = 0L)

shift_right(x, shift = 0L)

shift_upstream(x, shift = 0L)

shift_downstream(x, shift = 0L)
}
\arguments{
\item{x}{a Ranges object .}

\item{shift}{the amount to move the genomic interval in the Ranges object by.
Either a non-negative integer vector of length 1 or an integer vector
the same length as x.}
}
\value{
a Ranges object with start and end coordinates shifted.
}
\description{
Shift all coordinates in a genomic interval left or right, upstream or downstream
}
\details{
Shifting left or right will ignore any strand information
in the Ranges object, while shifting upstream/downstream will shift coordinates
on the positive strand left/right and the negative strand right/left. By
default, unstranded features are treated as positive. When
using \code{\link[=shift_upstream]{shift_upstream()}} or \code{\link[=shift_downstream]{shift_downstream()}} when the \code{shift} argument is
indexed by the strandedness of the input ranges.
}
\examples{
ir <- as_iranges(data.frame(start = 10:15, width = 5))
shift_left(ir, 5L)
shift_right(ir, 5L)
gr <- as_granges(data.frame(start = 10:15,
                            width = 5,
                            seqnames = "seq1",
                            strand = c("+", "+", "-", "-", "+", "*")))
shift_upstream(gr, 5L)
shift_downstream(gr, 5L)
}
\seealso{
\code{IRanges::\link[IRanges:intra-range-methods]{shift()}},
\code{GenomicRanges::\link[GenomicRanges:intra-range-methods]{shift()}}
}
