% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-genomeinfo.R
\name{ranges-info}
\alias{ranges-info}
\alias{genome_info}
\alias{set_genome_info}
\alias{get_genome_info}
\title{Construct annotation information}
\usage{
genome_info(
  genome = NULL,
  seqnames = NULL,
  seqlengths = NULL,
  is_circular = NULL
)

set_genome_info(
  .data,
  genome = NULL,
  seqnames = NULL,
  seqlengths = NULL,
  is_circular = NULL
)

get_genome_info(.data)
}
\arguments{
\item{genome}{A character vector of length one indicating the genome build.}

\item{seqnames}{A character vector containing the name of sequences.}

\item{seqlengths}{An optional integer vector containg the lengths of sequences.}

\item{is_circular}{An optional logical vector indicating whether a sequence is ciruclar.}

\item{.data}{A Ranges object to annotate or retrieve an annotation for.}
}
\value{
a GRanges object containing annotations. To retrieve the annotations
as a Ranges object use \code{get_genome_info}.
}
\description{
To construct annotations by supplying annotation information
use \code{genome_info}. To add
annotations to an existing Ranges object use \code{set_genome_info}. To retrieve
an annotation as a Ranges object use \code{get_genome_info}.
}
\examples{
x <- genome_info(genome = "toy",
                 seqnames = letters[1:4],
                 seqlengths = c(100, 300, 15, 600),
                 is_circular = c(NA, FALSE, FALSE, TRUE))
x

rng <- as_granges(data.frame(seqnames = "a", start = 30:50, width = 10))
rng
rng <- set_genome_info(rng,
                       genome = "toy",
                       seqnames = letters[1:4],
                       seqlengths = c(100, 300, 15, 600),
                       is_circular = c(NA, FALSE, FALSE, TRUE))
get_genome_info(rng)

\dontrun{
if (interactive()) {
 # requires internet connection
 genome_info(genome = "hg38")
}
}

}
\seealso{
\code{\link[Seqinfo:Seqinfo-class]{Seqinfo::Seqinfo()}}
}
