% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-arithmetic-flank.R
\name{flank_left}
\alias{flank_left}
\alias{flank_right}
\alias{flank_upstream}
\alias{flank_downstream}
\title{Generate flanking regions}
\usage{
flank_left(x, width = 0L)

flank_right(x, width = 0L)

flank_upstream(x, width = 0L)

flank_downstream(x, width = 0L)
}
\arguments{
\item{x}{a Ranges object.}

\item{width}{the width of the flanking region relative to the ranges in
\code{x}. Either an integer vector of length 1 or an integer vector
the same length as x. The width can be negative in which case the
flanking region is reversed.}
}
\value{
A Ranges object of same length as \code{x}.
}
\description{
Find flanking regions  to the left or right or
upstream or downstream of a Ranges object.
}
\details{
The function
\code{flank_left} will create the flanking region to the left of starting
coordinates in \code{x}, while \code{flank_right} will create the flanking
region to the right of the starting coordinates in \code{x}. The function
\code{flank_upstream} will \code{flank_left} if the strand of rows in \code{x} is
not negative and will \code{flank_right} if the strand of rows in \code{x} is
negative. The function \code{flank_downstream} will \code{flank_right} if the strand of rows in \code{x} is
not negative and will \code{flank_leftt} if the strand of rows in \code{x} is
negative.

By default \code{flank_left} and \code{flank_right} will
ignore strandedness of any ranges, while \code{flank_upstream} and
\code{flank_downstream} will take into account the strand of \code{x}.
}
\examples{
gr <- as_granges(data.frame(start = 10:15,
                            width = 5,
                            seqnames = "seq1",
                            strand = c("+", "+", "-", "-", "+", "*")))
flank_left(gr, width = 5L)
flank_right(gr, width = 5L)
flank_upstream(gr, width = 5L)
flank_downstream(gr, width = 5L)
}
\seealso{
\code{IRanges::\link[IRanges:intra-range-methods]{flank()}},
\code{GenomicRanges::\link[GenomicRanges:intra-range-methods]{flank()}}
}
