% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-expand.R
\name{expand_ranges}
\alias{expand_ranges}
\title{Expand list-columns in a Ranges object}
\usage{
expand_ranges(
  data,
  ...,
  .drop = FALSE,
  .id = NULL,
  .keep_empty = FALSE,
  .recursive = FALSE
)
}
\arguments{
\item{data}{A Ranges object}

\item{...}{list-column names to expand then unlist}

\item{.drop}{Should additional list columns be dropped (default = FALSE)?
By default \code{expand_ranges()} will keep other list columns even if they are nested.}

\item{.id}{A character vector of length equal to number of list columns.
If supplied will create new column(s) with name \code{.id}
identifying the index of the list column (default = NULL).}

\item{.keep_empty}{If a list-like column contains empty elements, should
those elements be kept? (default = FALSE)}

\item{.recursive}{If there are multiple list-columns, should the columns be
treated as parallel? If FALSE each column will be unnested recursively,
otherwise they are treated as parallel, that is each list column has
identical lengths. (deafualt = FALSE)}
}
\value{
a GRanges object with expanded list columns
}
\description{
Expand list-columns in a Ranges object
}
\examples{
grng <- as_granges(data.frame(seqnames = "chr1", start = 20:23, width = 1000))
grng <- mutate(grng, 
               exon_id = IntegerList(a = 1, b = c(4,5), c = 3, d = c(2,5))
               )
expand_ranges(grng)
expand_ranges(grng, .id = "name")

# empty list elements are not preserved by default
grng <- mutate(grng, 
               exon_id = IntegerList(a = NULL, b = c(4,5), c= 3, d = c(2,5))
               )
expand_ranges(grng)
expand_ranges(grng, .keep_empty = TRUE)
expand_ranges(grng, .id = "name", .keep_empty = TRUE)

}
