% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-construct.R
\name{as_iranges}
\alias{as_iranges}
\alias{as_granges}
\title{Construct a I/GRanges object from a tibble or data.frame}
\usage{
as_iranges(.data, ..., keep_mcols = TRUE)

as_granges(.data, ..., keep_mcols = TRUE)
}
\arguments{
\item{.data}{a \code{\link[=data.frame]{data.frame()}} or \code{\link[=tibble]{tibble()}} to
construct a Ranges object from}

\item{...}{optional named arguments specifying which the columns in .data
containin the core components a Ranges object.}

\item{keep_mcols}{place the remaining columns into the metadata columns slot
(default=TRUE)}
}
\value{
a Ranges object.
}
\description{
The as_i(g)ranges function looks for column names in .data called start,
end, width, seqnames and strand in order to construct an IRanges or GRanges
object. By default other columns in .data are placed into the mcols (
metadata columns) slot of the returned object.
}
\examples{
df <- data.frame(start=c(2:-1, 13:15), width=c(0:3, 2:0))
as_iranges(df)

df <- data.frame(start=c(2:-1, 13:15), width=c(0:3, 2:0), strand = "+")
# will return an IRanges object
as_iranges(df)

df <- data.frame(start=c(2:-1, 13:15), width=c(0:3, 2:0),
strand = "+", seqnames = "chr1")
as_granges(df)

# as_g/iranges understand alternate name specification
df <- data.frame(start=c(2:-1, 13:15), width=c(0:3, 2:0),
strand = "+", chr = "chr1")
as_granges(df, seqnames = chr)

# can also handle DFrame input
df <- methods::as(df, "DFrame")
df$y <- IRanges::IntegerList(c(1,2,3), NA, 5, 6, 8, 9, 10:12)
as_iranges(df)
as_granges(df, seqnames = chr)

}
\seealso{
\code{IRanges::\link[IRanges:IRanges-constructor]{IRanges()}},
\code{GenomicRanges::\link[GenomicRanges:GRanges-class]{GRanges()}}
}
