% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endo-coverage.R
\name{compute_coverage}
\alias{compute_coverage}
\title{Compute coverage over a Ranges object}
\usage{
compute_coverage(x, shift, width, weight, ...)
}
\arguments{
\item{x}{a \code{Ranges} object}

\item{shift}{shift how much should each range in x be shifted by? (default = 0L)}

\item{width}{width how long should the returned coverage score be?
This must be either a  positive integer or NULL (default = NULL)}

\item{weight}{weight how much weight should be assigned to each range? Either
an integer or numeric vector or a column in x. (default = 1L)}

\item{...}{other optional parameters to pass to coverage}
}
\value{
An expanded Ranges object with a score column corresponding to
the coverage value over that interval. Note that compute_coverage
drops metadata associated with the orginal ranges.
}
\description{
Compute coverage over a Ranges object
}
\examples{
rng <- as_iranges(data.frame(start = 1:10, width = 5))
compute_coverage(rng)
compute_coverage(rng, shift = 14L)
compute_coverage(rng, width = 10L)
}
\seealso{
\code{IRanges::\link[IRanges:coverage-methods]{coverage()}},
\code{GenomicRanges::\link[GenomicRanges:coverage-methods]{coverage()}}
}
