% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_ILR.R
\name{ilrp}
\alias{ilrp}
\alias{ilrpInv}
\title{Weighted ILR Transform}
\usage{
ilrp(y, p, V)

ilrpInv(y.star, V)
}
\arguments{
\item{y}{shifted data matrix (e.g., output of \link{shiftp})}

\item{p}{weights (should not be closed)}

\item{V}{weighted contrast matrix (e.g., output of \link{buildilrBasep})}

\item{y.star}{a data matrix that represents data transformed by \code{ilrp}}
}
\value{
matrix
}
\description{
Calculated using weighted CLR transform (\link{clrp})
}
\examples{
# Weights
p <- seq(.1,1,by=.2)

# Shifted Composition
c <- t(rmultinom(10,100,c(.1,.6,.2,.3,.2))) + 0.65   # add a small pseudocount
x <- miniclo(c)
y <- shiftp(x, p)

# Contrast Matrix
tr <- named_rtree(5)
sbp <- phylo2sbp(tr)
V <- buildilrBasep(sbp, p)

y.star <- ilrp(y, p, V)
y.star

# Untransform data (note use of shiftp and miniclo to return to x)
y.closed <- ilrpInv(y.star, V)
all.equal(miniclo(shiftpInv(y.closed, p)), x, check.attributes=FALSE)
}
\references{
J. J. Egozcue, V. Pawlowsky-Glahn (2016) \emph{Changing the Reference
  Measure in the Simplex and its Weighting Effects}. Austrian Journal of
  Statistics 45(4):25-44
}
\seealso{
\code{\link{philrInv}}
}
\author{
Justin Silverman
}
