% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_ILR.R
\name{g.rowMeans}
\alias{g.rowMeans}
\title{Weighted Geometric Means of Rows}
\usage{
g.rowMeans(y, p = rep(1, nrow(y)))
}
\arguments{
\item{y}{shifted data matrix (e.g., output of \link{shiftp})}

\item{p}{weights (should not be closed)}
}
\value{
vector (weighted geometric mean of rows)
}
\description{
Calculates weighted geometric mean (see references). Note
if \code{p=rep(1, nrow(y))} (default) then this is just the
geometric mean of rows.
}
\examples{
p <- seq(.1,1,by=.2)
c <- t(rmultinom(10,100,c(.1,.6,.2,.3,.2))) + 0.65   # add a small pseudocount
x <- miniclo(c)
y <- shiftp(x, p)
philr:::g.rowMeans(y, p)
}
\references{
J. J. Egozcue, V. Pawlowsky-Glahn (2016) \emph{Changing the Reference
  Measure in the Simplex and its Weighting Effects}. Austrian Journal of
  Statistics 45(4):25-44
}
\seealso{
\code{\link{g.colMeans}}
}
