% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_utils.R
\name{convert_to_long}
\alias{convert_to_long}
\title{Converts wide format ILR transformed data to long format}
\usage{
convert_to_long(x, labels)
}
\arguments{
\item{x}{PhILR transformed data in wide format (samples by balances)
(see \code{\link{philr}})}

\item{labels}{vector (of length \code{nrow(x)}) with labels to group
samples by}
}
\value{
\code{x} in long format with columns
\itemize{
\item sample
\item labels
\item coord
\item value
}
}
\description{
Converts wide format ILR transformed data (see \code{\link{philr}}) to
long format useful in various plotting functions where long format data is
required.
}
\examples{
tr <- named_rtree(5)
x <- t(rmultinom(10,100,c(.1,.6,.2,.3,.2))) + 0.65 # add small pseudocount
colnames(x) <- tr$tip.label

x.philr <- philr(x, tree=tr, part.weights='enorm.x.gm.counts',
   ilr.weights='blw.sqrt', return.all=FALSE)
   convert_to_long(x.philr, rep(c('a','b'), 5))
}
