% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_background.R
\name{create_background}
\alias{create_background}
\title{Create gene background}
\usage{
create_background(
  species1,
  species2,
  output_species = "human",
  as_output_species = TRUE,
  use_intersect = TRUE,
  bg = NULL,
  gene_map = NULL,
  method = "homologene",
  non121_strategy = "drop_both_species",
  verbose = TRUE
)
}
\arguments{
\item{species1}{First species.}

\item{species2}{Second species.}

\item{output_species}{Species to convert all genes from 
\code{species1} and \code{species2} to first.
 \code{Default="human"}, but can be to either any species
  supported by \pkg{orthogene}, including 
 \code{species1} or \code{species2}.}

\item{as_output_species}{Return background gene list as 
\code{output_species} orthologs, instead of the
 gene names of the original input species.}

\item{use_intersect}{When \code{species1} and \code{species2} are both
different from \code{output_species}, this argument will determine whether 
to use the intersect (\code{TRUE}) or union (\code{FALSE}) of all genes
from \code{species1} and \code{species2}.}

\item{bg}{User supplied background list that will be returned to the 
user after removing duplicate genes.}

\item{gene_map}{User-supplied \code{gene_map} data table from
\link[orthogene]{map_orthologs} or \link[orthogene]{map_genes}.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{non121_strategy}{How to handle genes that don't have
1:1 mappings between \code{input_species}:\code{output_species}.
Options include:\cr
\describe{
\item{\code{"drop_both_species" or "dbs" or 1}}{
Drop genes that have duplicate
mappings in either the \code{input_species} or \code{output_species}
(\emph{DEFAULT}).}
\item{\code{"drop_input_species" or "dis" or 2}}{
Only drop genes that have duplicate
mappings in the \code{input_species}.}
\item{\code{"drop_output_species" or "dos" or 3}}{
Only drop genes that have duplicate
mappings in the \code{output_species}.}
\item{\code{"keep_both_species" or "kbs" or 4}}{
Keep all genes regardless of whether
they have duplicate mappings in either species.}
\item{\code{"keep_popular" or "kp" or 5}}{
Return only the most "popular" interspecies ortholog mappings.
 This procedure tends to yield a greater number of returned genes
 but at the cost of many of them not being true biological 1:1 orthologs.}
 \item{\code{"sum","mean","median","min" or "max"}}{
 When \code{gene_df} is a matrix and \code{gene_output="rownames"},
  these options will aggregate many-to-one gene mappings
  (\code{input_species}-to-\code{output_species})
  after dropping any duplicate genes in the \code{output_species}.
 }
}}

\item{verbose}{Print messages.}
}
\value{
Background gene list.
}
\description{
Create a gene background as the union/intersect of 
all orthologs between input species (\code{species1} and \code{species2}), 
and the \code{output_species}. 
This can be useful when generating random lists of background genes 
to test against in analyses with data from multiple species
 (e.g. enrichment of mouse cell-type markers gene sets in
  human GWAS-derived gene sets).
}
\examples{
bg <- orthogene::create_background(species1 = "mouse", 
                                   species2 = "rat",
                                   output_species = "human")
}
