% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_species.R
\name{all_species}
\alias{all_species}
\title{All species}
\usage{
all_species(method = NULL, verbose = TRUE)
}
\arguments{
\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{verbose}{Print messages.}
}
\value{
\link[data.table]{data.table} of species names, 
provided in multiple formats.
}
\description{
List all species currently supported by \pkg{orthogene}.
Wrapper function for \link[orthogene]{map_species}.
When \code{method=NULL}, all species from all available 
methods will be returned.
}
\examples{
species_dt <- all_species()
}
