% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omXplore_density.R
\name{density-plot}
\alias{density-plot}
\alias{omXplore_density_ui}
\alias{omXplore_density_server}
\alias{densityPlot}
\alias{omXplore_density}
\title{Displays a correlation matrix of the quantitative data of a
numeric matrix.}
\usage{
omXplore_density_ui(id)

omXplore_density_server(
  id,
  dataIn = reactive({
     NULL
 }),
  i = reactive({
     1
 }),
  pal.name = reactive({
     NULL
 })
)

densityPlot(data, conds = NULL, pal.name = NULL)

omXplore_density(dataIn, i)
}
\arguments{
\item{id}{A \code{character(1)} which is the id of the shiny module.}

\item{dataIn}{An instance of the class \code{SummarizedExperiment}}

\item{i}{An integer which is the index of the assay in the param obj}

\item{pal.name}{A \code{character(1)} which is the name of the palette from
the package \link[RColorBrewer:ColorBrewer]{RColorBrewer::RColorBrewer} from which the colors are taken. Default
value is 'Set1'.}

\item{data}{A data.frame() of quantitative data}

\item{conds}{A vector indicating the name of each sample.}
}
\value{
NA

NA

A plot

A shiny app
}
\description{
Displays a correlation matrix of the quantitative data of a
numeric matrix.
}
\examples{
if (interactive()) {
    data(vdata)
    shiny::runApp(omXplore_density(vdata, 1))
}

if (interactive()) {
    data(vdata)
    qdata <- SummarizedExperiment::assay(vdata[[1]])
    conds <- get_group(vdata)
    densityPlot(qdata, conds)
}

}
