% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omXplore_PCA_nipals.R, R/omXplore_pca.R,
%   R/plot_pca.R
\name{ds-pca}
\alias{ds-pca}
\alias{my_PCA}
\alias{omXplore_pca_ui}
\alias{omXplore_pca_server}
\alias{omXplore_pca}
\alias{wrapper_pca}
\alias{plotPCA_Eigen}
\alias{plotPCA_Var}
\alias{plotPCA_Ind}
\alias{plotPCA_Eigen_hc}
\title{my_PCA}
\usage{
my_PCA(
  X,
  scale.unit = TRUE,
  ncp = min(12, nrow(X) - 1, ncol(X)),
  ind.sup = NULL,
  quanti.sup = NULL,
  quali.sup = NULL,
  row.w = NULL,
  col.w = NULL,
  graph = FALSE,
  axes = c(1, 2),
  approach = "FM",
  gramschmidt = TRUE
)

omXplore_pca_ui(id)

omXplore_pca_server(id, dataIn, i)

omXplore_pca(dataIn, i)

wrapper_pca(
  qdata,
  group,
  var.scaling = TRUE,
  ncp = NULL,
  approach = "FM",
  gramschmidt = TRUE
)

plotPCA_Eigen(res.pca)

plotPCA_Var(res.pca, chosen.axes = c(1, 2))

plotPCA_Ind(res.pca, chosen.axes = c(1, 2))

plotPCA_Eigen_hc(res.pca)
}
\arguments{
\item{X}{a data.frame() of quantitative data}

\item{scale.unit}{See \code{FactoMineR::PCA()}}

\item{ncp}{See \code{FactoMineR::PCA()}}

\item{ind.sup}{See \code{FactoMineR::PCA()}}

\item{quanti.sup}{See \code{FactoMineR::PCA()}}

\item{quali.sup}{See \code{FactoMineR::PCA()}}

\item{row.w}{See \code{FactoMineR::PCA()}}

\item{col.w}{See \code{FactoMineR::PCA()}}

\item{graph}{See \code{FactoMineR::PCA()}}

\item{axes}{See \code{FactoMineR::PCA()}}

\item{approach}{a string corresponding to the package to use for PCA (if no \code{NA}, default is "FM" for FactoMineR)}

\item{gramschmidt}{A boolean indicating whether to use Gram-Schmidt orthogonalization or not.}

\item{id}{A \code{character(1)} which is the id of the shiny module.}

\item{dataIn}{An instance of the class \code{MultiAssayExperiment}.}

\item{i}{An integer which is the index of the assay in the param obj}

\item{qdata}{A data.frame() of quantitative data}

\item{group}{A vector with the name of samples}

\item{var.scaling}{A boolean indicating whether to scale the data or not}

\item{res.pca}{The result of the function \code{FactoMineR::PCA()}}

\item{chosen.axes}{See the parameter 'axes' of the function
\code{factoextra::fviz_pca_var()}}
}
\value{
\code{res.pca} a \verb{"PCA"  "list"} object

NA

NA

A shiny app

The result of the function FactoMineR::PCA()

A plot

A plot

A plot

A plot
}
\description{
Process a PCA, using nipals or FactoMineR, on a quantitative dataset.

This method plots a bar plot which represents the distribution of the
number of missing values (NA) per lines (ie proteins).
\itemize{
\item \code{wrapper_pca()}
\item \code{plotPCA_Eigen_hc()}: plots the eigen values of PCA with the highcharts
library
\item \code{plotPCA_Eigen()}: plots the eigen values of PCA
\item \code{plotPCA_Var()}
\item \code{plotPCA_Ind()}
}
}
\examples{
data(vdata)
obj <- vdata[[1]]
res.pca <- my_PCA(SummarizedExperiment::assay(obj), approach = "FM")
plotPCA_Eigen(res.pca)
plotPCA_Var(res.pca)
plotPCA_Eigen_hc(res.pca)
plotPCA_Ind(res.pca)

\dontrun{
  data(vdata)
  library(shiny)
  library(QFeatures)
  library(shinyWidgets)
  library(dplyr)
  library(highcharter)
  # Replace missing values for the example
  sel <- is.na(SummarizedExperiment::assay(vdata, 1))
  SummarizedExperiment::assay(vdata[[1]])[sel] <- 0
  SummarizedExperiment::assay(vdata[[1]])[1,1] <- NA
  omXplore_pca(vdata, 1)
}


data(vdata)
obj <- vdata[[1]]
res.pca <- wrapper_pca(qdata=SummarizedExperiment::assay(obj), group=get_group(obj))
plotPCA_Eigen(res.pca)
plotPCA_Var(res.pca)
plotPCA_Eigen_hc(res.pca)
plotPCA_Ind(res.pca)

}
\author{
Samuel Wieczorek, Enora Fremy
}
