% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSegment.R
\name{reduceSegment}
\alias{reduceSegment}
\title{Combine nearby regions with same state}
\usage{
reduceSegment(x, col = "state")
}
\arguments{
\item{x}{the input GRanges}

\item{col}{the name of the column for the segment states}
}
\value{
a GRanges with metadata column \code{state}
giving the segmentation state
}
\description{
Combine nearby regions with same state
}
\examples{

n <- 10000
library(GenomicRanges)
gr <- GRanges("chr1", IRanges(round(
  c(runif(n/4,1,991), runif(n/4,1001,3991),
    runif(n/4,4001,4991), runif(n/4,7001,9991))),
  width=10), seqlengths=c(chr1=10000))
gr$name <- rep(1:4,each=10)
gr <- sort(gr)
seg <- reduceSegment(gr, col="name")

}
