% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSeqContent.R
\docType{methods}
\name{plotSeqContent}
\alias{plotSeqContent}
\alias{plotSeqContent,ANY-method}
\alias{plotSeqContent,FastqcData-method}
\alias{plotSeqContent,FastqcDataList-method}
\alias{plotSeqContent,FastpData-method}
\alias{plotSeqContent,FastpDataList-method}
\title{Plot the per base content as a heatmap}
\usage{
plotSeqContent(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotSeqContent}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotSeqContent}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  bases = c("A", "T", "C", "G"),
  scaleColour = NULL,
  plotTheme = theme_get(),
  plotlyLegend = FALSE,
  expand.x = 0.02,
  expand.y = c(0, 0.05),
  ...
)

\S4method{plotSeqContent}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  showPwf = TRUE,
  plotType = c("heatmap", "line", "residuals"),
  scaleColour = NULL,
  plotTheme = theme_get(),
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  plotlyLegend = FALSE,
  nc = 2,
  ...
)

\S4method{plotSeqContent}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  module = c("Before_filtering", "After_filtering"),
  reads = c("read1", "read2"),
  readsBy = c("facet", "linetype"),
  moduleBy = c("facet", "linetype"),
  bases = c("A", "T", "C", "G", "N", "GC"),
  scaleColour = NULL,
  scaleLine = NULL,
  plotlyLegend = FALSE,
  plotTheme = theme_get(),
  expand.x = 0.02,
  expand.y = c(0, 0.05),
  ...
)

\S4method{plotSeqContent}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  module = c("Before_filtering", "After_filtering"),
  moduleBy = c("facet", "linetype"),
  reads = c("read1", "read2"),
  readsBy = c("facet", "linetype"),
  bases = c("A", "T", "C", "G", "N", "GC"),
  showPwf = FALSE,
  pwfCols,
  warn = 10,
  fail = 20,
  plotType = c("heatmap", "line", "residuals"),
  plotlyLegend = FALSE,
  scaleColour = NULL,
  scaleLine = NULL,
  plotTheme = theme_get(),
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  expand.x = c(0.01),
  expand.y = c(0, 0.05),
  nc = 2,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or file paths}

\item{usePlotly}{\code{logical}. Generate an interactive plot using plotly}

\item{labels}{An optional named vector of labels for the file names.
All file names must be present in the names of the vector.}

\item{pattern}{Regex to remove from the end of any filenames}

\item{...}{Used to pass additional attributes to plotting geoms}

\item{bases}{Which bases to draw on the plot. Also becomes the default
plotting order by setting these as factor levels}

\item{scaleColour}{Discrete colour scale as a ggplot ScaleDiscrete object
If not provided, will default to \link[ggplot2]{scale_colour_manual}}

\item{plotTheme}{\link[ggplot2]{theme} object to be applied. Note that all
plots will have \link[ggplot2]{theme_bw} theme applied by default, as well as
any additional themes supplied here}

\item{plotlyLegend}{logical(1) Show legends for interactive plots. Ignored
for heatmaps}

\item{expand.x, expand.y}{Passed to \link[ggplot2]{expansion} in the x- and
y-axis scales respectively}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} to give colours for
pass, warning, and fail
values in plot}

\item{showPwf}{Show PASS/WARN/FAIL categories as would be defined in a FastQC
report}

\item{plotType}{\code{character}. Type of plot to generate. Must be "line",
"heatmap" or "residuals"}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{heat_w}{Relative width of any heatmap plot components}

\item{nc}{Specify the number of columns if plotting a FastqcDataList as line
plots. Passed to \link[ggplot2]{facet_wrap}.}

\item{module}{Fastp Module to show. Can only be Before/After_filtering}

\item{reads}{Which set of reads to show}

\item{readsBy, moduleBy}{When plotting both R1 & R2 and both modules,
separate by either linetype or linetype}

\item{scaleLine}{Discrete scale_linetype object. Only relevant if plotting
values by linetype}

\item{warn, fail}{Default values for WARN and FAIL based on FastQC reports.
Only applied to heatmaps for FastpDataList objects}
}
\value{
A ggplot2 object or an interactive plotly object
}
\description{
Plot the Per Base content for a set of FASTQC files.
}
\details{
Per base sequence content (\%A, \%T, \%G, \%C), is shown as four overlaid
heatmap colours when plotting from multiple reports. The individual line
plots are able to be generated by setting \code{plotType = "line"}, and the
layout is determined by \code{facet_wrap} from ggplot2.

Individual line plots are also generated when plotting from a single
\code{FastqcData} object.

If setting \code{usePlotly = TRUE} for a large number of reports, the plot
can be slow to render.
An alternative may be to produce a plot of residuals for each base, produced
by taking the position-specific mean for each base.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# The default plot
plotSeqContent(fdl)

fp <- FastpData(system.file("extdata/fastp.json.gz", package = "ngsReports"))
plotSeqContent(fp)
plotSeqContent(fp, moduleBy = "linetype", bases = c("A", "C", "G", "T"))

}
