% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBaseQuals.R
\docType{methods}
\name{plotBaseQuals}
\alias{plotBaseQuals}
\alias{plotBaseQuals,ANY-method}
\alias{plotBaseQuals,FastqcData-method}
\alias{plotBaseQuals,FastqcDataList-method}
\alias{plotBaseQuals,FastpData-method}
\alias{plotBaseQuals,FastpDataList-method}
\title{Plot the Base Qualities for each file}
\usage{
plotBaseQuals(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotBaseQuals}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotBaseQuals}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 25,
  fail = 20,
  boxWidth = 0.8,
  showPwf = TRUE,
  plotlyLegend = FALSE,
  ...
)

\S4method{plotBaseQuals}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 25,
  fail = 20,
  showPwf = TRUE,
  boxWidth = 0.8,
  plotType = c("heatmap", "boxplot"),
  plotValue = "Mean",
  cluster = FALSE,
  dendrogram = FALSE,
  nc = 2,
  heat_w = 8L,
  ...
)

\S4method{plotBaseQuals}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 25,
  fail = 20,
  showPwf = FALSE,
  module = c("Before_filtering", "After_filtering"),
  reads = c("read1", "read2"),
  readsBy = c("facet", "linetype"),
  bases = c("A", "T", "C", "G", "mean"),
  scaleColour = NULL,
  plotTheme = theme_get(),
  plotlyLegend = FALSE,
  ...
)

\S4method{plotBaseQuals}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 25,
  fail = 20,
  showPwf = FALSE,
  module = c("Before_filtering", "After_filtering"),
  plotType = "heatmap",
  plotValue = c("mean", "A", "T", "C", "G"),
  scaleFill = NULL,
  plotTheme = theme_get(),
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8L,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or character
vector of file paths}

\item{usePlotly}{\code{logical} Default \code{FALSE} will render using
ggplot. If \code{TRUE} plot will be rendered with plotly}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.}

\item{pattern}{Regex to remove from the end of the Fastp report and Fastq
file names}

\item{...}{Used to pass additional attributes to theme() and between methods}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} to give colours for
pass, warning, and fail values in plot}

\item{warn, fail}{The default values for warn and fail are 30 and 20
respectively (i.e. percentages)}

\item{boxWidth}{set the width of boxes when using a boxplot}

\item{showPwf}{Include the Pwf status colours}

\item{plotlyLegend}{logical(1) Show legend for interactive plots. Only called
when drawing line plots}

\item{plotType}{\code{character} Can be either \code{"boxplot"} or
\code{"heatmap"}}

\item{plotValue}{\code{character} Type of data to be presented. Can be
any of the columns returned by the appropriate call to \code{getModule()}}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{nc}{\code{numeric}. The number of columns to create in the plot layout.
Only used if drawing boxplots for multiple files in a FastqcDataList}

\item{heat_w}{Relative width of any heatmap plot components}

\item{module}{Select Before and After filtering when using a FastpDataList}

\item{reads}{Create plots for read1, read2 or all when using a FastpDataList}

\item{readsBy}{If paired reads are present, separate using either linetype
or by facet}

\item{bases}{Which bases to include on the plot}

\item{scaleColour}{ggplot discrete colour scale, passed to lines}

\item{plotTheme}{\link[ggplot2]{theme} object}

\item{scaleFill}{ggplot2 continuous scale. Passed to heatmap cells}
}
\value{
A standard ggplot2 object or an interactive plotly object
}
\description{
Plot the Base Qualities for each file as separate plots
}
\details{
When acting on a \code{FastqcDataList}, this defaults to a heatmap
using the mean Per_base_sequence_quality score. A set of plots which
replicate those obtained through a standard FastQC html report can be
obtained by setting \code{plotType = "boxplot"}, which uses \code{facet_wrap}
to provide the layout as a single ggplot object.

When acting an a \code{FastqcData} object, this replicates the
\verb{Per base sequence quality} plots from FastQC with no faceting.

For large datasets, subsetting by R1 or R2 reads may be helpful.

An interactive plot can be obtained by setting \code{usePlotly = TRUE}.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# The default plot for multiple libraries is a heatmap
plotBaseQuals(fdl)

# The default plot for a single library is the standard boxplot
plotBaseQuals(fdl[[1]])

# FastpData objects have qyalities by base
fp <-  FastpData(system.file("extdata/fastp.json.gz", package = "ngsReports"))
plotBaseQuals(
  fp, plotTheme = theme(plot.title = element_text(hjust = 0.5))
)

}
