% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColours.R
\name{getColours}
\alias{getColours}
\alias{getColours,PwfCols-method}
\alias{setColours}
\alias{setColours,PwfCols-method}
\alias{setAlpha}
\alias{setAlpha,PwfCols-method}
\title{Work with objects of class PwfCols}
\usage{
\S4method{getColours}{PwfCols}(object)

\S4method{setColours}{PwfCols}(object, PASS, WARN, FAIL, MAX)

\S4method{setAlpha}{PwfCols}(object, alpha)
}
\arguments{
\item{object}{An object of class PwfCols}

\item{PASS}{The colour denoting PASS on all plots, in rgb format}

\item{WARN}{The colour denoting WARN on all plots, in rgb format}

\item{FAIL}{The colour denoting FAIL on all plots, in rgb format}

\item{MAX}{The colour denoting the limit of values in rgb format}

\item{alpha}{Numeric(1). Ranges from 0 to 1 by default, but can also be on
the range 0 to 255.}
}
\value{
getColours will return a character vector of colours coresponding to
PASS/WARN/FAIL

setColours will return an object of class PwfCols

setAlpha will return an object of class PwfCols
}
\description{
Get and modify colours from objects of class PwfCols
}
\details{
Use \code{getColours} to obtain the colours in an object of class PwfCols.

These can be modified using the functions \code{setColours} and
\code{setAlpha}
}
\examples{
getColours(pwf)

# How to add transparency
pwf2 <- setAlpha(pwf, 0.1)
getColours(pwf2)

}
