% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estGcDistn.R
\docType{methods}
\name{estGcDistn}
\alias{estGcDistn}
\alias{estGcDistn,ANY-method}
\alias{estGcDistn,character-method}
\alias{estGcDistn,DNAStringSet-method}
\title{Estimate a GC Content Distribution From Sequences}
\usage{
estGcDistn(x, n = 1e+06, rl = 100, fl = 200, fragSd = 30, bins = 101, ...)

\S4method{estGcDistn}{ANY}(x, n = 1e+06, rl = 100, fl = 200, fragSd = 30, bins = 101, ...)

\S4method{estGcDistn}{character}(x, n = 1e+06, rl = 100, fl = 200, fragSd = 30, bins = 101, ...)

\S4method{estGcDistn}{DNAStringSet}(x, n = 1e+06, rl = 100, fl = 200, fragSd = 30, bins = 101, ...)
}
\arguments{
\item{x}{\code{DNAStringSet} or path to a fasta file}

\item{n}{The number of reads to sample}

\item{rl}{Read Lengths to sample}

\item{fl}{The mean of the fragment lengths sequenced}

\item{fragSd}{The standard deviation of the fragment lengths being sequenced}

\item{bins}{The number of bins to estimate}

\item{...}{Not used}
}
\value{
A \code{tibble} with two columns: \code{GC_Content} and \code{Freq}
denoting the proportion of GC and frequency of occurence reqpectively
}
\description{
Generate a GC content distribution from sequences for a given
read length and fragment length
}
\details{
The function takes the supplied object and returns the theoretical GC
content distribution. Using a fixed read length essentially leads to a
discrete distribution so the bins argument is used to define the number of
bins returned. This defaults to 101 for 0 to 100\% inclusive.

The returned values are obtained by interpolating the values obtained during
sampling. This avoids returned distributions with gaps and jumps as would be
obtained setting readLengths at values not in multiples of 100.

Based heavily on https://github.com/mikelove/fastqcTheoreticalGC
}
\examples{
faDir <- system.file("extdata", package = "ngsReports")
faFile <- list.files(faDir, pattern = "fasta", full.names = TRUE)
df <- estGcDistn(faFile, n = 200)

}
