% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMetrics.R
\name{plotMetrics}
\alias{plotMetrics}
\title{plotMetrics}
\usage{
plotMetrics(
sce,
detected = "detected",
subsets_mito_percent = "subsets_mito_percent",
palette = "#33ADFF"
)
}
\arguments{
\item{sce}{(SingleCellExperiment) Input data object.}

\item{detected}{(character) Column name in sce giving the number of unique
genes detected per cell. This name is inherited by default from scater's
addPerCellQC() function.}

\item{subsets_mito_percent}{(character) Column name in sce giving the
percent of reads mapping to mitochondrial genes. This name is inherited
from scater's addPerCellQC() function, provided the subset "mito" with
names of all mitochondrial genes is passed in. See examples for details.}

\item{palette}{(character) Specifies the color to plot cells as. Default is
"#33ADFF".}
}
\value{
Returns a ggplot object. Additional plot elements can be added as
ggplot elements (e.g. title, customized formatting, etc).
}
\description{
A function to plot the QC parameters used for a miQC model, number of unique
genes expressed and percent mitochondrial reads. This function can be run
before calling mixtureModel() to assess if miQC is appropriate given the data
distribution. See vignette for examples of cases where miQC is and isn't a
good choice for filtering.
}
\examples{
library(scRNAseq)
library(scater)
sce <- ZeiselBrainData()
mt_genes <- grepl("^mt-",  rownames(sce))
feature_ctrls <- list(mito = rownames(sce)[mt_genes])
sce <- addPerCellQC(sce, subsets = feature_ctrls)
plotMetrics(sce)
}
