% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testProbeProximity.R
\name{testProbeProximity}
\alias{testProbeProximity}
\title{testProbeProximity tests if a query set of probes share closer
genomic proximity than if randomly distributed}
\usage{
testProbeProximity(
  probeIDs,
  gr = NULL,
  platform = NULL,
  iterations = 100,
  bin_size = 1500
)
}
\arguments{
\item{probeIDs}{Vector of probes of interest (e.g., significant probes)}

\item{gr}{GRanges to draw samples and compute genomic distances}

\item{platform}{String corresponding to the type of platform to use. Either
MM285, EPIC, HM450, or HM27. If it is not provided, it will be inferred
from the query set probeIDs (Default: NA).}

\item{iterations}{Number of random samples to generate null distribution
(Default: 100).}

\item{bin_size}{the poisson interval size for computing neighboring hits}
}
\value{
list containing a dataframe for the poisson statistics and a
data frame for the probes in close proximity
}
\description{
testProbeProximity tests if a query set of probes share closer
genomic proximity than if randomly distributed
}
\examples{
sesameData::sesameDataCache(data_titles=
c("MM285.tissueSignature","MM285.address","probeIDSignature"))
library(SummarizedExperiment)
df <- rowData(sesameData::sesameDataGet("MM285.tissueSignature"))
probes <- df$Probe_ID[df$branch == "B_cell"]
res <- testProbeProximity(probeIDs=probes,platform="MM285")
sesameData::sesameDataGet_resetEnv()

}
