% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{annoProbes}
\alias{annoProbes}
\title{Annotate Probe IDs using KYCG databases}
\usage{
annoProbes(
  probeIDs,
  databases,
  db_names = NULL,
  platform = NULL,
  sep = ",",
  indicator = FALSE,
  silent = FALSE
)
}
\arguments{
\item{probeIDs}{probe IDs in a character vector}

\item{databases}{character or actual database (i.e. list of probe IDs)}

\item{db_names}{specific database (default to all databases)}

\item{platform}{EPIC, MM285 etc. will infer from probe IDs if not given}

\item{sep}{delimiter used in paste}

\item{indicator}{return the indicator matrix instead of a concatenated
annotation (in the case of have multiple annotations)}

\item{silent}{suppress message}
}
\value{
named annotation vector, or indicator matrix
}
\description{
see sesameData_annoProbes if you'd like to annotate by genomic coordinates
(in GRanges)
}
\examples{
sesameData::sesameDataCache(data_titles=
c("MM285.address","probeIDSignature","KYCG.MM285.designGroup.20210210"))
probes <- names(sesameData::sesameData_getManifestGRanges("MM285"))
anno <- annoProbes(probeIDs=probes, "designGroup", silent = TRUE)
}
