% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-ScreePlot.R
\docType{class}
\name{ScreePlot-class}
\alias{ScreePlot-class}
\alias{ScreePlot}
\title{Scree plot}
\value{
The \code{ScreePlot(...)} constructor creates an instance of an ScreePlot
class, where any slot and its value can be passed to \code{...} as a named
argument.
}
\description{
Contribution of each reduced dimension component to explained variance. The
reduced dimension should be stored in the
\code{\link[SingleCellExperiment:reducedDims]{reducedDim}} slot of a
\code{\link[SingleSummarizedExperiment:SingleSummarizedExperiment-class]{SingleSummarizedExperiment}}.
This panel uses \code{\link[miaViz:plotScree]{plotScree}} to generate the
plot.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualisation:
\itemize{
\item \code{dimred} \code{Character scalar} or \code{integer scalar}.
Determines the reduced dimension to plot. This is used when \code{x} is a
\code{TreeSummarizedExperiment} to extract the eigenvalues from
\code{reducedDim(x, dimred)}.

\item \code{show.barplot}: \code{Logical scalar}. Whether to show a barplot.
(Default: \code{TRUE})

\item \code{show.points}: \code{Logical scalar}. Whether to show points.
(Default: \code{TRUE})

\item \code{show.line}: \code{Logical scalar}. Whether to show lines.
(Default: \code{TRUE})

\item \code{show.labels}: \code{Logical scalar}. Whether to show a label for
each point. (Default: \code{FALSE})

\item \code{add.proportion}: \code{Logical scalar}. Whether to show proportion of
explained variance, i.e., raw eigenvalues. (Default: \code{TRUE})

\item \code{add.cumulative}: \code{Logical scalar}. Whether to show cumulative
explained variance calculated from eigenvalues. (Default: \code{FALSE})

\item \code{n}: \code{Integer scalar}. Number of eigenvalues to plot. If
unspecified, all eigenvalues are plotted. (Default: \code{NULL})

\item \code{show.names}: \code{Logical scalar}. Whether to show names of the
components on the x-axis. If \code{FALSE}, indices are shown instead.
(Default: \code{FALSE})

\item \code{eig.name}: \code{Character scalar}. The name of the attribute in
\code{reducedDim(x, dimred)} that contains the eigenvalues.
(Default: \code{c("eig", "varExplained")})
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\examples{
# Import libraries
library(mia)
library(scater)

# Import TreeSE
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Add relabundance assay
tse <- transformAssay(tse, method = "relabundance")

# Add reduced dimensions
tse <- runPCA(tse, assay.type = "relabundance")

# Store panel into object
panel <- ScreePlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\seealso{
\linkS4class{LoadingPlot}
\linkS4class{RDAPlot}
}
\author{
Giulio Benedetti
}
