% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgsets.R
\name{rgsets}
\alias{rgsets}
\title{A relational genesets object}
\description{
A relational genesets object

A relational genesets object
}
\section{See Also}{


\code{gsets}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{genesets}}{A list of genesets where list names refers to geneset labels and values are geneset members represented as a vector}

\item{\code{nodes}}{A data frame of labeled nodes}

\item{\code{edges}}{A data frame of directed edges}

\item{\code{name}}{A character vector describing source of genesets}

\item{\code{version}}{A character vector describing versioning}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rgsets-new}{\code{rgsets$new()}}
\item \href{#method-rgsets-print}{\code{rgsets$print()}}
\item \href{#method-rgsets-info}{\code{rgsets$info()}}
\item \href{#method-rgsets-reduce}{\code{rgsets$reduce()}}
\item \href{#method-rgsets-subset}{\code{rgsets$subset()}}
\item \href{#method-rgsets-clone}{\code{rgsets$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgsets-new"></a>}}
\if{latex}{\out{\hypertarget{method-rgsets-new}{}}}
\subsection{Method \code{new()}}{
Create a rgsets object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rgsets$new(
  genesets,
  nodes,
  edges,
  name = "Custom",
  version = "",
  quiet = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genesets}}{A list of genesets where list names refers to geneset labels and values are geneset members represented as a vector}

\item{\code{nodes}}{A data frame of labeled nodes}

\item{\code{edges}}{A data frame of directed edges}

\item{\code{name}}{A character vector describing source of genesets}

\item{\code{version}}{A character vector describing versioning}

\item{\code{quiet}}{Use true to silence warnings}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new rgsets object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgsets-print"></a>}}
\if{latex}{\out{\hypertarget{method-rgsets-print}{}}}
\subsection{Method \code{print()}}{
Print relational genesets information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rgsets$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgsets-info"></a>}}
\if{latex}{\out{\hypertarget{method-rgsets-info}{}}}
\subsection{Method \code{info()}}{
Returns versioning information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rgsets$info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with name and version
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgsets-reduce"></a>}}
\if{latex}{\out{\hypertarget{method-rgsets-reduce}{}}}
\subsection{Method \code{reduce()}}{
Reduces genesets to a background distribution of symbols
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rgsets$reduce(background)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{background}}{A character vector of symbols}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A rgsets object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgsets-subset"></a>}}
\if{latex}{\out{\hypertarget{method-rgsets-subset}{}}}
\subsection{Method \code{subset()}}{
Subsets genesets on a character vector of labels
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rgsets$subset(labels)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{labels}}{A character vector of genesets}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A rgsets object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgsets-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rgsets-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rgsets$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
