% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_rectangular}
\alias{layout_rectangular}
\alias{layout_circular}
\alias{layout_inward_circular}
\alias{layout_fan}
\alias{layout_dendrogram}
\title{layout_rectangular}
\usage{
layout_rectangular()

layout_circular()

layout_inward_circular(xlim = NULL)

layout_fan(angle = 180)

layout_dendrogram()
}
\arguments{
\item{xlim}{setting x limits, which will affect the center space of the tree}

\item{angle}{open tree at specific angle}
}
\description{
transform circular/fan layout to rectangular layout

transform rectangular layout to circular layout

transform rectangular/circular layout to inward circular layout

transform rectangular/circular layout to fan layout

transform rectangular layout to dendrogram layout
}
\examples{
tree <- rtree(20)
p <- ggtree(tree, layout = "circular") + layout_rectangular()
tree <- rtree(20)
p <- ggtree(tree)
p + layout_circular()
tree <- rtree(20)
p <- ggtree(tree)
p + layout_inward_circular(xlim=4) + geom_tiplab(hjust=1)
tree <- rtree(20)
p <- ggtree(tree)
p + layout_fan(angle=90)
tree <- rtree(20)
p <- ggtree(tree)
p + p + layout_dendrogram()
}
\author{
Guangchuang Yu
}
