% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gheatmap.R
\name{gheatmap}
\alias{gheatmap}
\title{gheatmap}
\usage{
gheatmap(
  p,
  data,
  offset = 0,
  width = 1,
  low = "green",
  high = "red",
  color = "white",
  colnames = TRUE,
  colnames_position = "bottom",
  colnames_angle = 0,
  colnames_level = NULL,
  colnames_offset_x = 0,
  colnames_offset_y = 0,
  font.size = 4,
  family = "",
  hjust = 0.5,
  legend_title = "value",
  custom_column_labels = NULL
)
}
\arguments{
\item{p}{tree view}

\item{data}{matrix or data.frame}

\item{offset}{set offset of the heatmap to tree}

\item{width}{total width of heatmap, compare to width of tree, defaults to 1,
which means they are of the same length}

\item{low}{set color of the lowest value, defaults to "green"}

\item{high}{set color of the highest value, defaults to "red"}

\item{color}{set color of heatmap cell border, defaults to "white"}

\item{colnames}{logical, whether to add matrix colnames, defaults to "TRUE"}

\item{colnames_position}{set the position of the colnames, one of 'bottom' (default) or 'top'}

\item{colnames_angle}{set the angle of colnames}

\item{colnames_level}{set levels of colnames}

\item{colnames_offset_x}{set x offset for colnames}

\item{colnames_offset_y}{set y offset for colnames}

\item{font.size}{set font size of matrix colnames}

\item{family}{font of matrix colnames, can be any supported font}

\item{hjust}{adjust horizonal position of column names (0: align left, 0.5: align center (default), 1: align righ)}

\item{legend_title}{title of fill legend}

\item{custom_column_labels}{instead of using the colnames from the input matrix/data.frame,
input a custom vector to be set as column labels}
}
\value{
tree view
}
\description{
append a heatmap of a matrix to the right side of a phylogenetic tree
}
\references{
For demonstration of this function, please refer to chapter 7.3 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Guangchuang Yu
}
