% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clade-functions.R
\name{collapse.ggtree}
\alias{collapse.ggtree}
\title{collapse-ggtree}
\usage{
\method{collapse}{ggtree}(x = NULL, node, mode = "none", clade_name = NULL, ...)
}
\arguments{
\item{x}{tree view (i.e. the ggtree object). If tree_view is NULL, the last ggplot will be used.}

\item{node}{internal node number}

\item{mode}{one of 'none'(default), 'max', 'min' and 'mixed'. 'none' would simply collapse the clade as 'tip' and
the rest will display a triangle, whose shape is determined by the farest/closest tip of the collapsed clade to indicate it}

\item{clade_name}{set a name for the collapsed clade. If clade_name = NULL, do nothing}

\item{...}{additional parameters to set the color or transparency of the triangle}
}
\value{
tree view
}
\description{
collapse a selected clade, which can later be expanded with the 'expand()' fuction if necessary
}
\examples{
x <- rtree(15)
p <- ggtree(x) + geom_tiplab()
p
p1 <- collapse(p, node = 17, mode = "mixed", 
               clade_name = "cclade", alpha = 0.8, 
               color = "grey", fill = "light blue")
}
\seealso{
expand
}
\author{
Guangchuang Yu
}
