% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_tiplab.R
\name{label_pad}
\alias{label_pad}
\title{Padding taxa labels}
\usage{
label_pad(label, justify = "right", pad = "·")
}
\arguments{
\item{label}{taxa label}

\item{justify}{should a character vector be right-justified (default), left-justified, centred or left alone.}

\item{pad}{padding character (defaults to dots)}
}
\value{
Taxa labels with padding characters added
}
\description{
This function adds padding characters to the left side of taxa labels, adjust their length to the longest label.
}
\examples{
library(ggtree)
set.seed(2015-12-21)
tree <- rtree(5)
tree$tip.label[2] <- "long string for test"
label_pad(tree$tip.label)
}
\references{
\url{https://groups.google.com/g/bioc-ggtree/c/INJ0Nfkq3b0/m/lXefnfV5AQAJ}
}
\author{
Guangchuang Yu and Yonghe Xia
}
