% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialDistanceMatrix.R
\name{spatialDistanceMatrix}
\alias{spatialDistanceMatrix}
\alias{boundaryScore}
\alias{boundaryScoreTAD}
\alias{hierarchicalClusteringTAD}
\alias{compartment}
\alias{spatialDistanceHeatmap}
\title{Create the spatial distance matrix}
\usage{
spatialDistanceMatrix(xyz, output = "matrix", fill_NA = FALSE, ...)

boundaryScore(spatialDistances, window = 5, background = 10, ...)

boundaryScoreTAD(
  spatialDistances,
  bin_size,
  window = 5,
  Z_cutoff = 2.3,
  norm = FALSE,
  boundaryScores,
  ...
)

hierarchicalClusteringTAD(spatialDistances, bin_size, window = 5, k, ...)

compartment(xyz.gr, genome, minWidth = 1)

spatialDistanceHeatmap(
  spatialDistances,
  components = c("compartment", "boundaryScoreTAD", "hierarchicalClusteringTAD"),
  col = hcl.colors(n = 12, "OrRd"),
  at = seq(0, 1, length.out = 2),
  label_unit = "M",
  window = 5,
  background = 10,
  d_cutoff = Inf,
  Z_cutoff = 2.3,
  norm = FALSE,
  Gaussian_blur = FALSE,
  useRaster = FALSE,
  ...
)
}
\arguments{
\item{xyz}{A GRanges object with x, y, z coordinates}

\item{output}{"matrix" or "dist".}

\item{fill_NA}{Fill the missing value or not.}

\item{...}{Parameters could be used by downstream function.}

\item{spatialDistances}{The output of spatialDistanceMatrix or the input of spatialDistanceMatrix.}

\item{window}{The window size for boundary score.}

\item{background}{The background window size for local background.}

\item{bin_size}{The bin size.}

\item{Z_cutoff}{The Z_cutoff value for boundary.}

\item{norm}{Normalize the boundary score or not.}

\item{boundaryScores}{The output of boundaryScore.}

\item{k}{The cluster number. The final TAD numbers will be no greater than this number.}

\item{xyz.gr}{A GRanges object with x,y,z coordinates.}

\item{genome}{A BSgenome object}

\item{minWidth}{The minimal width of input region.}

\item{components}{The components to plot.}

\item{col}{a list of colors such as that generated by hcl.colors, gray.colors or similar functions.}

\item{at}{The label position of X, and Y axis.}

\item{label_unit}{unit for labels. 'M', 1e6; 'K', 1e3, 'G', 1e9.}

\item{d_cutoff}{The maximal cutoff value of distance matrix.}

\item{Gaussian_blur}{Do Gaussian blur or not.}

\item{useRaster}{logical; if TRUE a bitmap raster is used to plot the image instead of polygons.}
}
\value{
A matrix of Euclidean distance with fixed bins.

boundaryScore return a data frame with the boundary score and the Z scores.

boundaryScoreTAD return a list of the index or the positions of coordinates.

hierarchicalClusteringTAD return a list of the index or the positions of coordinates.

compartment return a GRanges object with A,B annotations.
}
\description{
Create the spatial distance matrix for given 3D coordinates.

boundaryScore calculate the boundary score for a distance matrix.
Please note that, this boundary score is the reverse of insulation score
because we are using the distance matrix but not the interaction matrix.

boundaryScoreTAD assign the TAD boundaries via boundary score.

hierarchicalClusteringTAD assign the TAD boundaries via hierarchical clustering.

compartment calculate the compartment by principal component analysis.

spatialDistanceHeatmap will use base R to plot the spatial distance matrix.
}
\examples{
xyz.gr <- readRDS(system.file('extdata', '4DNFI1UEG1HD.chr21.FLAMINGO.res.rds',
 package='geomeTriD'))
bin_size <- 5000 #width(xyz.gr)[1]
sdm <- spatialDistanceMatrix(xyz.gr)
spatialDistanceHeatmap(sdm)
head(boundaryScoreTAD(sdm, bin_size=bin_size))
head(hierarchicalClusteringTAD(sdm, bin_size=bin_size))
library(BSgenome.Hsapiens.UCSC.hg19)
compartment(xyz.gr, genome=BSgenome.Hsapiens.UCSC.hg19)
}
