% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth3dPoints.R
\name{smooth3dPoints}
\alias{smooth3dPoints}
\title{Calculate the smoothed curve for input GRanges}
\usage{
smooth3dPoints(obj, resolution = 30, ...)
}
\arguments{
\item{obj}{GRanges object with mcols x, y, and z}

\item{resolution}{number of points at which to evaluate the smooth curve.}

\item{...}{parameters passed to \link[stats]{splinefun}}
}
\value{
GRanges object with smoothed points of x0, y0, z0,
x1, y1, and z1.
}
\description{
This function will do smooth for given resolution (tile) for inputs and
it is important step to prepare the inputs for \link{create3dGenomicSignals}
and \link{view3dStructure}.
}
\examples{
library(GenomicRanges)
obj <- GRanges("1", IRanges(seq.int(5) * 10, width = 10),
  x = seq.int(5), y = seq.int(5), z = seq.int(5)
)
smooth3dPoints(obj, 5)

}
