% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{get_gene_differential_expression_values}
\alias{get_gene_differential_expression_values}
\title{Retrieve the differential expression results for a given gene among datasets matching the provided query and filter}
\usage{
get_gene_differential_expression_values(
  gene,
  query = NA_character_,
  taxa = NA_character_,
  uris = NA_character_,
  filter = NA_character_,
  threshold = 1,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{gene}{An ensembl gene identifier which typically starts with ensg or an ncbi gene identifier or an official gene symbol approved by hgnc}

\item{query}{The search query. Queries can include plain text or ontology
terms They also support conjunctions ("alpha AND beta"), disjunctions ("alpha OR beta")
grouping ("(alpha OR beta) AND gamma"), prefixing ("alpha*"), wildcard characters
("BRCA?") and fuzzy matches ("alpha~").}

\item{taxa}{A vector of taxon common names (e.g. human, mouse, rat). Providing multiple
species will return results for all species. These are appended
to the filter and equivalent to filtering for \code{taxon.commonName} property}

\item{uris}{A vector of ontology term URIs. Providing multiple terms will
return results containing any of the terms and their children. These are
appended to the filter and equivalent to filtering for \code{allCharacteristics.valueUri}}

\item{filter}{Filter results by matching expression. Use \code{\link{filter_properties}}
function to get a list of all available parameters. These properties can be
combined using "and" "or" clauses and may contain common operators such as "=", "<" or "in".
(e.g. "taxon.commonName = human", "taxon.commonName in (human,mouse), "id < 1000")}

\item{threshold}{number}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data.table containing differential expression results. This table
is stripped down some relevant information for speed of execution. Details about
the contrasts can be accessesed via \code{\link{get_result_sets}} function

The fields of the output data.table are:

\itemize{
\item \code{result.ID}: Result set ID of the differential expression analysis.
May represent multiple factors in a single model.
\item \code{contrast.ID}: Id of the specific contrast factor. Together with the result.ID
they uniquely represent a given contrast.
\item \code{experiment.ID}: Id of the source experiment
\item \code{factor.coefficient}: Model coefficient calculated for the specific contrast factor
\item \code{factor.logfc}: Log 2 fold change calculated for the specific contrast factor
\item \code{factor.pvalue}: p values calculated for the specific contrast factor
}
}
\description{
Retrieve the differential expression results for a given gene among datasets matching the provided query and filter
}
\examples{
# get all differential expression results for ENO2
# from datasets marked with the ontology term for brain
head(get_gene_differential_expression_values(2026, uris = "http://purl.obolibrary.org/obo/UBERON_0000955"))

}
\keyword{gene}
