% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemma.R.R
\docType{package}
\name{gemma.R}
\alias{gemma.R-package}
\alias{gemma.R}
\title{gemma.R package: Access curated gene expression data and differential expression analyses}
\description{
This package contains wrappers and convenience functions for Gemma's RESTful API
that enables access to curated expression and differential expression data
from over 15,000 published studies (as of mid-2022). Gemma (https://gemma.msl.ubc.ca) is a web site, database and a set
of tools for the meta-analysis, re-use and sharing of transcriptomics data,
currently primarily targeted at the analysis of gene expression profiles.
}
\details{
Most users will want to start with the high-level functions like \code{\link{get_dataset_object}}, \code{\link{get_differential_expression_values}} and \code{\link{get_platform_annotations}}
Additional lower-level methods are available that directly map to the Gemma RESTful API methods.

For more information and detailed usage instructions check the
\href{https://pavlidislab.github.io/gemma.R/index.html}{README}, the
\href{https://pavlidislab.github.io/gemma.R/reference/index.html}{function reference}
and the \href{https://pavlidislab.github.io/gemma.R/articles/gemma.R.html}{vignette}.

All software-related questions should be posted to the Bioconductor Support Site:
\url{https://support.bioconductor.org}
}
\references{
Lim, N. et al., Curation of over 10 000 transcriptomic studies to enable
data reuse, Database, 2021. \url{https://doi.org/10.1093/database/baab006}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://pavlidislab.github.io/gemma.R/}
  \item \url{https://github.com/PavlidisLab/gemma.R}
  \item Report bugs at \url{https://github.com/PavlidisLab/gemma.R/issues}
}

}
\author{
Javier Castillo-Arnemann, Jordan Sicherman, Ogan Mancarci, Guillaume Poirier-Morency
}
