% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strandedness.R
\name{identifyStrandMode}
\alias{identifyStrandMode}
\alias{strandedness,character-method}
\alias{strandedness,BamFileList-method}
\alias{classifyStrandMode}
\alias{strnessByFeature}
\title{Identify strandMode}
\usage{
identifyStrandMode(
  bfl,
  txdb,
  singleEnd,
  stdChrom = TRUE,
  exonsBy = c("gene", "tx"),
  minnaln = 2e+05,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)

\S4method{strandedness}{character}(
  x,
  txdb,
  singleEnd,
  stdChrom = TRUE,
  exonsBy = c("gene", "tx"),
  minnaln = 2e+05,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)

\S4method{strandedness}{BamFileList}(
  x,
  txdb,
  singleEnd,
  stdChrom = TRUE,
  exonsBy = c("gene", "tx"),
  minnaln = 2e+05,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)

classifyStrandMode(
  strnessdat,
  strcutoff = 0.9,
  weakstrcutoff = 0.6,
  warnweakstr = TRUE
)

strnessByFeature(
  bfl,
  features,
  singleEnd = TRUE,
  strandMode = 1L,
  yieldSize = 1000000L,
  ambiguous = FALSE,
  p = 0.6,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)
}
\arguments{
\item{bfl}{A \code{\link[Rsamtools:BamFile-class]{BamFile}} or
\code{\link[Rsamtools:BamFile-class]{BamFileList}} object, or a character string vector
of BAM filenames.}

\item{txdb}{A character string of a \code{TxDb} package, or a \code{TxDb}
object, with gene and transcript annotations. For accurate calculations, it
is important that the version of these annotations matches the version of
the annotations used to inform the alignment of spliced reads, by the
short-read aligner software that generated the input BAM files.}

\item{singleEnd}{(Default FALSE) Logical value indicating if reads are
single (\code{TRUE}) or paired-end (\code{FALSE}).}

\item{stdChrom}{(Default TRUE) Logical value indicating whether only
alignments in the 'standard chromosomes' should be used. Consult the help
page of the function \code{\link[GenomeInfoDb]{keepStandardChromosomes}()}
from the package \code{GenomeInfoDb} for further information.}

\item{exonsBy}{(Default 'gene') Character string, either \code{gene} or
\code{tx}, respectively specifying whether exon annotations should be
grouped by gene or by transcript, in the estimation of strandedness values.
Consult the help page of the function \code{\link[GenomicFeatures]{exonsBy}()}
from the package \code{GenomicFeatures} for further information.}

\item{minnaln}{(Default 200000) Minimum number of read alignments overlapping
exonic regions considered necessary for a reliable estimation of strandedness
values. A warning message is given if the number of such available alignments
is smaller than the one given through this parameter.}

\item{verbose}{(Default TRUE) Logical value indicating if progress should be
reported through the execution of the code.}

\item{BPPARAM}{An object of a
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}} subclass
to configure the parallel execution of the code. By default, a
\code{\link[BiocParallel:SerialParam-class]{SerialParam}} object is used, which does
not use any parallelization, with the flag \code{progress=TRUE} to show
progress through the calculations.}

\item{x}{A \code{\link[Rsamtools:BamFile-class]{BamFileList}} object.}

\item{strnessdat}{A \code{data.frame} object obtained with the function
\code{\link{strandedness}()}.}

\item{strcutoff}{(Default 0.9) Minimum cutoff above which a strandedness
value is considered to strongly support that read alignments originate from
a specific strand.}

\item{weakstrcutoff}{(Default 0.6) Minimum cutoff above which a strandedness
value is considered to weakly support that read alignments originate from a
specific strand.}

\item{warnweakstr}{(Default TRUE) Logical value indicating whether to warn
the user when strandedness values only provide a weakly support for a
specific strand.}

\item{features}{A \code{GRanges} or \code{GRangesList} object with
annotations of features (e.g. genes, transcripts, etc.).}

\item{strandMode}{(Default 1L) Numeric vector which can take values 0, 1,
or 2. The strand mode is a per-object switch on
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
objects that controls the behavior of the strand getter. See
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail. If \code{singleEnd = TRUE}, then \code{strandMode}
is ignored.}

\item{yieldSize}{(Default 5e5) Field inherited from
\code{\link[Rsamtools]{BamFile}}. The BAM is read by chunks.
\code{yieldSize} represents the number of records to read for each chunk.}

\item{ambiguous}{(Default FALSE) Logical value indicating if reads that
overlap a region with features annotated to both strands should be included
in the strandedness value computation.}

\item{p}{(Default 0.6) Numeric value for the exact binomial test performed
for the strandedness value of each feature, representing the hypothesized
probability of success (i.e. the strandedness value expected for a
non-stranded dataset).}
}
\value{
A \link[base:list]{list} object with two elements:
\itemize{
\item "strandMode": the \code{strandMode} of the sample(s) following
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class definition. If all samples have the same \code{strandMode},
the length of the vector is 1. It can take values: \code{NA}
(library is not strand-specific), 1 (strand of pair is strand of
its first alignment), 2 (strand of pair is strand of its second
alignment) or "ambiguous" (additional category used here for
samples not fitting any of the three previous categories).
See "Details" section below to know the classification criteria,
as well as to how interpret results for single-end data.
\item "Strandedness": data.frame with one row per sample and 3 columns.
"strandMode1": proportion of alignments aligned to the same
strand than a transcript according
to the strand of its first alignment. "strandMode2": proportion
of alignments aligned to the same strand than a transcript according
to the strand of its second alignment. "ambiguous": alignments
aligned to regions with transcripts in both strands.
}

A vector of integer values, \code{NA}, \code{1}, or \code{2},

A \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
with three assays:
\itemize{
\item "strness": contains strandedness values for each feature and sample.
\item "counts": number of reads aligning to each feature on the same
strand (according to \code{strandMode}).
\item "counts_invstrand": number of reads aligning to each feature but on
the opposite strand (according to \code{strandMode}).
}
}
\description{
THIS FUNCTION HAS BEEN DEPRECATED, HAS BEEN REPLACED BY \code{strandedness()}
AND WILL WILL BE DEFUNCT AT THE NEXT RELEASE.

Identify \code{strandMode} (strandedness) in RNA-seq data samples based on
Given strandedness values calculated assuming either the same or the opposite
strand of gene annotations, classify them into an strand mode according to
cutoff values specified in the parameters.

Compute strandedness for each feature in RNA-seq data samples based on
the proportion of reads aligning to the same strand as feature annotations
in relation to the total number of reads aligning to that feature.
}
\details{
Identify \code{strandMode} (strandedness) in RNA-seq data samples based on
the proportion of reads aligning to the same or opposite strand as
transcripts in the annotations.

If the value in the "strandMode1" column is > 0.90, \code{strandMode} is set
to 1L. If "strandMode2" column is > 0.90, \code{strandMode} is set to 2L. If
"strandMode1" and "strandMode2" are comprised between 0.40 and 0.60,
\code{strandMode} is set to \code{NA} If none of the three previous criteria
are met, \code{strandMode} is set to "ambiguous". This criteria can be
conservative in some cases (e.g. when there is genomic DNA contamination),
for this reason we recommend to check the data.frame with strandedness
values.

In case of single-end data, the same criteria are used, but the
interpretation of \code{strandMode = 1L} and \code{strandMode = 2L}
changes: when \code{strandMode = 1L} the strand of the read is concordant
with the reference annotations, when \code{strandMode = 2L} the correct
read strand is the opposite to the one of the read.

A subset of 200,000 alignments overlapping gene annotations are used to
compute strandedness.

Strandedness is computed for each feature and BAM file according to the
\code{strandMode} specified in case of paired-end data. For single-end,
the original strand of reads is used. All alignments from the BAM file(s)
are considered to compute the strandedness.

The \code{p} value should be close to 0.5, representing the strandedness
expected for a non-stranded RNA-seq library.
}
\examples{
library(gDNAinRNAseqData)

library(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene

# Retrieving BAM files
bamfiles <- LiYu22subsetBAMfiles()
bamfiles <- bamfiles[c(1,7)] # using a subset of samples

strandM <- identifyStrandMode(bamfiles, txdb, singleEnd=FALSE)
strandM$strandMode
head(strandM$Strandedness)


strnessdat <- data.frame(strandMode1=c(0.91, 0.92, 0.93),
                         strandMode2=c(0.09, 0.08, 0.07))
classifyStrandMode(strnessdat)

features <- range(exonsBy(txdb, by="gene"))
features <- features[1:100]
sByFeature <- strnessByFeature(bamfiles, features, singleEnd=FALSE,
                            strandMode=2L)
sByFeature

}
