% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_trans.R
\name{flow_breaks}
\alias{flow_breaks}
\title{Generate the breaks that makes sense for flow data visualization}
\usage{
flow_breaks(x, n = 6, equal.space = FALSE, trans.fun, inverse.fun)
}
\arguments{
\item{x}{the raw data values}

\item{n}{desired number of breaks (the actual number will be different depending on the data range)}

\item{equal.space}{whether breaks at equal-spaced intervals}

\item{trans.fun}{the transform function (only needed when equal.space is TRUE)}

\item{inverse.fun}{the inverse function (only needed when equal.space is TRUE)}
}
\value{
either 10^n intervals or equal-spaced(after transformed) intervals in raw scale.
}
\description{
It is mainly used as helper function to construct breaks function used by 'trans_new'.
}
\examples{
library(flowCore)
data(GvHD)
fr <- GvHD[[1]]
data.raw <- exprs(fr)[, "FL1-H"]
flow_breaks(data.raw)

trans <- logicleTransform()
inv <- inverseLogicleTransform(trans = trans)
myBrks <- flow_breaks(data.raw, equal.space = TRUE, trans = trans, inv = inv)
round(myBrks)
#to verify it is equally spaced at transformed scale
print(trans(myBrks))
}
