% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_helpers.R
\name{loop_ind_f}
\alias{loop_ind_f}
\title{Prepares parallel loop indices.}
\usage{
loop_ind_f(x, n)
}
\arguments{
\item{x}{A vector of loop indices.}

\item{n}{An integer, or the number of vectors to split \code{x} into.}
}
\value{
list of \code{n} vectors with elements from \code{x}.
}
\description{
\code{loop_ind_f} is a helper function that splits
 a vector of loop indices into a list of multiple loop indices
 for use in parallel processes within the flowGraph package.
}
\examples{

 old_loop_inds <- 1:10
 no_cores <- 5

 new_loop_inds <- flowGraph:::loop_ind_f(old_loop_inds, no_cores)
 # future::plan(future::multisession)
 # example_indices <- furrr::future_map(new_loop_inds, function(ii) {
 #     purrr::map(ii, function(i) i )
 # s})

}
