% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_flowGraphSubset_constructor.R
\name{get_child}
\alias{get_child}
\title{Gets child populations of given cell populations}
\usage{
get_child(parens, pchild, pc_i, ac__, meta_cell__)
}
\arguments{
\item{parens}{Character vector of cell population phenotypes.}

\item{pchild}{Edge list where the name of the list is the cell population
and the vector in each element contains the child cell populations of the
named cell population.}

\item{pc_i}{A cell population x marker matrix where the values are 0/1/2/...
correspondng to marker conditions /-/+/... for possible PARENT populations.}

\item{ac__}{A list where the elements are marker index > "0"/"1"/"2"/... >
a logical vector the same length as the number of cell population phenotypes
indicating whether or not the marker condition exists in them; this is for
the possible CHILD cell populations}

\item{meta_cell__}{data frame with meta data for cell population phenotypes
from the flowGraph object; this is for the possible CHILD cell populations.}
}
\value{
A list containing child populations of \code{parens}; also globally
 updates \code{pchild}.
}
\description{
Gets the child populations of a vector of given cell populations
 \code{parens} and updates \code{pchild} the edge list if edge list doesn't contain
 the requested information.
}
\seealso{
\code{\link[purrr]{map}},\code{\link[purrr]{keep}}
}
