% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_flowgraph_plots.R
\name{fg_save_plots}
\alias{fg_save_plots}
\title{Saves numerous plots for all summary statistics to a folder.}
\usage{
fg_save_plots(
  fg,
  plot_path,
  plot_types = "node",
  interactive = FALSE,
  adjust_custom = "byLayer",
  label_max = 10,
  box_no = 20,
  paired = FALSE,
  logged = FALSE,
  filter_adjust0 = 1,
  filter_es = 0,
  filter_btwn_tpthres = 1,
  filter_btwn_es = 0,
  overwrite = TRUE,
  node_labels = "NONE",
  ...
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{plot_path}{A string indicating the folder path to where the function
should save the plots.}

\item{plot_types}{A string or a vector of strings indicating what feature
types and their summaries the function should plot for: 'node' or 'edge'.}

\item{interactive}{A logical indicating whether the QQ plot, p-value vs
difference plot, and the
cell hierarchy plots should be interactive; see functions
\code{fg_plot} and \code{fg_plot_qq}.}

\item{adjust_custom}{A function or a string indicating the
test adjustment method to use.
 If a string is provided, it should be one of
 \code{c("holm", "hochberg", "hommel",
 "bonferroni", "BH", "BY", "fdr", "none")} (see \code{p.adjust.methods}).
 If a function is provided, it should take as input
 a numeric vector and output the
 same vector adjusted.}

\item{label_max}{An integer indicating how many labels should be shown
in the functions \code{fg_plot_pVSdiff} and \code{fg_plot}.}

\item{box_no}{An integer indicating the maximum number of boxplots to save;
used in function \code{fg_plot_box}.}

\item{paired}{A logical indicating whether the summary is paired; used in
function \code{fg_plot_box}.}

\item{logged}{A logical indicating whether or not to log the summary
statistic p value in the qq plots.}

\item{filter_adjust0}{A numeric variable indicating what percentage of
SpecEnr values compared (minimum) should be not close to 0.
Set to 1 to not conduct filtering. This parameter is used for the QQ and the
pVSdifference plots.}

\item{filter_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant.}

\item{filter_btwn_tpthres}{A numeric variable between 0 and 1 indicating the
unadjusted T-test p-value threshold used to test whether the actual
and expected feature values used to calculate the specified SpecEnr
feature are significantly different for each sample class. Note this only
needs to be specified for SpecEnr features. Combined
with \code{filter_btwn_es}, we conduct three tests to understand if
there is an actual large difference between actual and expected features:
(1,2) T-test of significance between the actual and expected raw feature value
(e.g. proportion) for samples in each of the compared classes, (3) and the
T-test of significance between the differences of actual and
expected feature values of the two classes. If any two of the three tests
come out as insignificant, we set the p-value for the associated node/edge
to 1.}

\item{filter_btwn_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant -- see \code{filter_btwn_tpthres}.}

\item{overwrite}{A logical variable indicating whether or not to replace
old plots if they exist under the same folder name.}

\item{node_labels}{Parameter for the \code{fg_plot} function.}

\item{...}{Other parameters for the \code{fg_plot} function.}
}
\value{
No return; plots are saved to file.
}
\description{
Saves numerous plots for all summary statistics in a given
 flowGraph object to a user specified folder.
}
\details{
The interactive plots are made using the \code{ggiraph} package.
}
\examples{

 no_cores <- 1
 data(fg_data_pos2)
 fg <- flowGraph(fg_data_pos2$count,
                 class=fg_data_pos2$meta$class,
                 no_cores=no_cores)

 fg_save_plots(fg, "temp")

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_plot}}
 \code{\link[flowGraph]{plot_gr}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_plot_qq}}
 \code{\link[flowGraph]{fg_plot_pVSdiff}}
 \code{\link[flowGraph]{fg_plot_box}}
}
