% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_save}
\alias{fg_save}
\title{Saves flowGraph object to a specified path.}
\usage{
fg_save(fg, folder_path = NULL, save_plots = TRUE, paired = FALSE, ...)
}
\arguments{
\item{fg}{flowGraph object to save.}

\item{folder_path}{A string indicating the folder path to where the flowGraph
object should save its elements; if this is the first time the object is
being saved, this folder should be empty or if it is
not yet created, the function will create it. If the object has previously
been saved before and this parameter is set to \code{NULL}, the function
will save the object into the save folder it was previously saved in.}

\item{save_plots}{A logical indicating whether or not to save plots.}

\item{paired}{A logical indicating whether the summary is paired; used in
function \code{fg_plot_box}.}

\item{...}{Other parameters for the \code{fg_save_plots} function.}
}
\value{
TRUE if flowGraph object successfully saved.
}
\description{
Saves flowGraph object to a specified path.
}
\details{
See generated README.md file.
}
\examples{
 no_cores <- 1
 data(fg_data_pos2)
 fg <- flowGraph(fg_data_pos2$count, class=fg_data_pos2$meta$class,
                 no_cores=no_cores)

 fg_save(fg, "tmp")

}
\seealso{
\code{length},\code{c("nrow", "nrow")},\code{NULL}
 \code{\link[purrr]{map}}
}
