% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_rm_summary}
\alias{fg_rm_summary}
\title{Removes a feature summary.}
\usage{
fg_rm_summary(fg, type = "node", index = NULL, summary_meta = NULL)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for;
'node' or 'edge'.}

\item{index}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{index} is an integer indicating the row in
 \code{fg_get_summary_desc(<flowGraph>)} of the corresponding type and
 summary the user would like to retrieve.}

\item{summary_meta}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{summary_meta} is a list containing
 \code{feat} (feature name), \code{test_name} (summary statistic name),
 \code{class} (class), \code{label1}, and \code{label2} (class labels compared).
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.}
}
\value{
flowGraph object.
}
\description{
Removes a feature summary from a given flowGraph object;
 while \code{fg} is required, the user can choose to input parameters
 \code{summary_meta}, \code{index}, or all of \code{type},
 \code{feat}, \code{test_name}, \code{class}, \code{label1},
  and \code{label2}.
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- fg_summary(fg, no_cores=no_cores, class="class", label1="control",
                  overwrite=FALSE, test_name="wilcox_byLayer", diminish=FALSE,
                  node_features=NULL, edge_features=NULL)
 fg_get_summary_desc(fg)

 fg <- fg_rm_summary(fg, summary_meta=c(
     feature="count",test_name="wilcox_byLayer",
     class="class", label1="control", label2="exp"))
 fg_get_summary_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_rm_feature}}
}
