% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_summary}
\alias{fg_get_summary}
\title{Retrieves a summary statistic.}
\usage{
fg_get_summary(
  fg,
  type = "node",
  index = NULL,
  summary_meta = NULL,
  adjust_custom = "byLayer",
  SpecEnr_filt = TRUE,
  summary_fun = colMeans,
  adjust0_lim = c(-0.1, 0.1),
  filter_adjust0 = 1,
  filter_es = 0,
  filter_btwn_tpthres = 0.05,
  filter_btwn_es = 0.5,
  default_p_thres = 1
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for
'node' or 'edge'.}

\item{index}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{index} is an integer indicating the row in
 \code{fg_get_summary_desc(<flowGraph>)} of the corresponding type and
 summary the user would like to retrieve.}

\item{summary_meta}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{summary_meta} is a list containing
 \code{feat} (feature name), \code{test_name} (summary statistic name),
 \code{class} (class), \code{label1}, and \code{label2} (class labels compared).
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.}

\item{adjust_custom}{A function or a string indicating the
test adjustment method to use.
 If a string is provided, it should be one of
 \code{c("holm", "hochberg", "hommel",
 "bonferroni", "BH", "BY", "fdr", "none")} (see \code{p.adjust.methods}).
 If a function is provided, it should take as input
 a numeric vector and output the
 same vector adjusted.}

\item{SpecEnr_filt}{A logicle indicating whether or not to filter p-values
for SpecEnr.}

\item{summary_fun}{A function that takes in a matrix and outputs a
vector the same length as the number of columns this matrix has.
Set to \code{NULL} to not calculate this summary
(i.e. returned list will not contain \code{m1} and \code{m2}).
See \code{\link[flowGraph]{fg_get_feature_means}}.}

\item{adjust0_lim}{A vector of two numeric values indicating a range around
0, default set to -0.1 and 0.1.}

\item{filter_adjust0}{A numeric variable indicating what percentage of
SpecEnr values compared (minimum) should be not close to 0.
Set to 1 to not conduct filtering. Original p-values stored in
\code{values_original}.}

\item{filter_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant.}

\item{filter_btwn_tpthres}{A numeric variable between 0 and 1 indicating the
unadjusted T-test p-value threshold used to test whether the actual
and expected feature values used to calculate the specified SpecEnr
feature are significantly different for each sample class. Note this only
needs to be specified for SpecEnr features. Combined
with \code{filter_btwn_es}, we conduct three tests to understand if
there is an actual large difference between actual and expected features:
(1,2) T-test of significance between the actual and expected raw feature value
(e.g. proportion) for samples in each of the compared classes, (3) and the
T-test of significance between the differences of actual and
expected feature values of the two classes. If any two of the three tests
come out as insignificant, we set the p-value for the associated node/edge
to 1.}

\item{filter_btwn_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant -- see \code{filter_btwn_tpthres}.}

\item{default_p_thres}{A numeric variable indicating the p-value threshold
user is using. Currently, all nodes/edges not passing the \code{filter}
criterion will be defaulted to 1; if this parameter is set, then all
of these nodes/edges will be set to a minimum of \code{default_p_thres}.}
}
\value{
A list containing elements on feature summary retrieved by the user
 as in the \code{summary} slot of
 \code{\link[flowGraph]{flowGraph-class}}.
 If \code{summary_fun} is not \code{NULL}, this list also includes:
 \itemize{
  \item{\code{m1}: a numeric vector the same length as \code{values};
  this is a summary of the samples compared e.g. mean.}
  \item{\code{m2}: a numeric vector the same length as \code{values};
  this is a summary of the samples compared e.g. mean.}
  \item{\code{cohensd}: a numberic vector indicating cohen's d values
   considering effect size.}
  \item{\code{cohensd_size}: a factor vector interpreting cohen's d values.}
  \item{\code{adjust0}: a numeric vector indicating the percentage of
   samples that have a SpecEnr value in the range of \code{adjust0_lim}
   around 0; if there are two classes of samples being compared, we output
   the smaller percentage between the two classes.}
  \item{\code{btwn}: a data frame containing columns:
   \itemize{
    \item{\code{tpv1}: unadjusted p-value calculated
     between the actual and expected raw feature values of class 1.}
    \item{\code{tpv2}: unadjusted p-value calculated
     between the actual and expected raw feature values of class 2.}
    \item{\code{cd1}: Cohen's D between the actual and expected raw
     feature values of class 1.}
    \item{\code{cd2}: Cohen's D between the actual and expected raw
     feature values of class 2.}
    \item{\code{btp}: unadjusted p-value calculated between the
     difference between actual and expected raw feature of the two classes.}
    \item{\code{bcd}: Cohen's D calculated between the
     difference between actual and expected raw feature of the two classes.}
    \item{\code{btp_}: unadjusted p-value calculated between the
     log ratio between actual and expected raw feature of the two classes.}
    \item{\code{bcd_}: Cohen's D calculated between the
     log ratio between actual and expected raw feature of the two classes.}
   }
  }
 }
}
\description{
Retrieves a summary statistic from a given flowGraph object;
 while \code{fg} is required, the user can choose to input parameters
 \code{summary_meta}, \code{index}, or all of \code{type},
 \code{feat}, \code{test_name}, \code{class}, \code{label1}, and \code{label2}.
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 # set features to NULL to apply summary statistic to all features.
 fg <- fg_summary(fg, no_cores=no_cores, class="class", label1="control",
                  overwrite=FALSE, test_name="t", diminish=FALSE,
                  node_features=NULL, edge_features=NULL)
 show(fg)

 feat_summ <- fg_get_summary(fg, type="node", summary_meta=list(
     feature="SpecEnr", test_name="t", class="class",
     label1="control", label2="exp"))

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_means}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_get_feature}}
}
