% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_extract_raw}
\alias{fg_extract_raw}
\title{Clears all features and feature summaries in a flowGraph object.}
\usage{
fg_extract_raw(fg)
}
\arguments{
\item{fg}{flowGraph object.}
}
\value{
flowGraph object with all summary statistics and feature values
 removed except for the node count feature.
}
\description{
Returns a flowGraph object with only the \code{count} feature
 and meta data. This function clears all other features and
 feature summaries to save space.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 fg <- fg_extract_raw(fg)
 show(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
}
