% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_gate-methods.R
\name{shift_gate}
\alias{shift_gate}
\alias{shift_gate.default}
\title{Simplified geometric translation of gates}
\usage{
\method{shift_gate}{default}(obj, dx = NULL, dy = NULL, center = NULL, ...)
}
\arguments{
\item{obj}{A Gate-type \code{\link{filter}} object (\code{\linkS4class{quadGate}},
\code{\linkS4class{rectangleGate}}, \code{\linkS4class{ellipsoidGate}}, or \code{\linkS4class{polygonGate}})}

\item{dx}{Either a numeric scalar or numeric vector. If it is scalar, this is just the desired shift of the gate in 
its first dimension. If it is a vector, it specifies both \code{dx} and \code{dy} as \code{(dx,dy)}.
This provides an alternate syntax for shifting gates, as well as allowing shifts of \code{ellipsoidGate} objects
in more than 2 dimensions.}

\item{dy}{A numeric scalar specifying the desired shift of the gate in its second dimension.}

\item{center}{A numeric vector specifying where the center or centroid should be moved (rather than specifiying \code{dx} 
and/or \code{dy})}

\item{\dots}{Additional arguments not used}
}
\value{
A Gate-type \code{filter} object of the same type as \code{gate}, with the translation applied
}
\description{
Shift a Gate-type filter object in one or more dimensions
}
\details{
This method allows for geometric translation of filter types defined by simple geometric gates 
(\code{rectangleGate}, \code{quadGate}, \code{\linkS4class{ellipsoidGate}}, or \code{\linkS4class{polygonGate}}).
The method provides two approaches to specify a translation. For \code{rectangleGate} objects, this will
shift the \code{min} and \code{max} bounds by the same amount in each specified dimension. For \code{quadGate}
objects, this will simply shift the divinding boundary in each dimension. For \code{ellipsoidGate} objects, this
will shift the center (and therefore all points of the ellipse). For \code{polgonGate} objects, this will simply
shift all of the points defining the polygon.

The method allows two different approaches to shifting a gate. Through the \code{dx} and/or \code{dy} arguments,
a direct shift in each dimension can be provided. Alternatively, through the \code{center} argument, the gate
can be directly moved to a new location in relation to the old center of the gate. For \code{quadGate} objects, 
this center is the intersection of the two dividing boundaries (so the value of the \code{boundary} slot). For
\code{rectangleGate} objects, this is the center of the rectangle defined by the intersections of the centers
of each interval. For \code{ellipsoidGate} objects, it is the center of the ellipsoid, given by the \code{mean}
slot. For \code{polygonGate} objects, the centroid of the old polygon will be calculated and shifted to the new
location provided by \code{center} and all other points on the polygon will be shifted by relation to the centroid.
}
\examples{
\dontrun{
# Moves the entire gate +500 in its first dimension and 0 in its second dimension
shifted_gate <- shift_gate(original_gate, dx = 500)

#Moves the entire gate +250 in its first dimension and +700 in its second dimension
shifted_gate <- shift_gate(original_gate, dx = 500, dy = 700)

# Same as previous
shifted_gate <- shift_gate(original_gate, c(500,700))

# Move the gate based on shifting its center to (700, 1000)
shifted_gate <- shift_gate(original_gate, center = c(700, 1000))
}

}
