% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ratiotGml2-class}
\alias{ratiotGml2-class}
\alias{ratiotGml2}
\alias{eval,ratiotGml2,missing-method}
\alias{initialize,ratiotGml2-method}
\alias{parameters,ratiotGml2-method}
\title{Class "ratiotGml2"}
\description{
Ratio transformation as parameterized in Gating-ML 2.0.
}
\details{
ratiotGml2 is defined by the following function: 
\deqn{bound(f, boundMin, boundMax) =
max(min(f,boundMax),boundMin))} where 
\deqn{f(p1, p2, A, B, C) = A * (p1 - B) / (p2 - C)}

If a boundary is defined by the boundMin and/or boundMax parameters, then
the result of this transformation is restricted to the [boundMin,boundMax]
interval. Specifically, should the result of the f function be less than
boundMin, then let the result of this transformation be boundMin.
Analogically, should the result of the f function be more than boundMax,
then let the result of this transformation be boundMax. The boundMin
parameter shall not be greater than the boundMax parameter.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{function}.}

\item{\code{numerator}}{Object of class \code{"transformation"} -- flow parameter to be 
used as numerator in the transformation function.}

\item{\code{denominator}}{Object of class \code{"transformation"} -- flow parameter to be 
used as denominator in the transformation function.}

\item{\code{pA}}{Object of class \code{numeric} constant A.}

\item{\code{pB}}{Object of class \code{numeric} constant B.}

\item{\code{pC}}{Object of class \code{numeric} constant C.}

\item{\code{transformationId}}{Object of class \code{"character"} -- unique ID to reference 
the transformation.}

\item{\code{boundMin}}{Object of class \code{numeric} -- lower bound of the transformation, default -Inf.}

\item{\code{boundMax}}{Object of class \code{numeric} -- upper bound of the transformation, default Inf.}
}}

\note{
The ratiotGml2 transformation object can be evaluated using the eval
method by passing the data frame as an argument. The transformed parameters
are returned as matrix with one column. (See example below)
}
\section{Objects from the Class}{
 Objects can be created by calls to the
constructor

\code{ratiotGml2(p1, p2, A, B, C, transformationId, boundMin, boundMax)}
}

\section{Extends}{

Class \code{"\linkS4class{transform}"}, directly.

Class \code{"\linkS4class{transformation}"}, by class "transform", distance 2.

Class \code{"\linkS4class{characterOrTransformation}"}, by class "transform", distance 3.
}

\examples{

myDataIn <- read.FCS(system.file("extdata", "0877408774.B08", 
    package="flowCore"))
myRatioT <- ratiotGml2("FSC-H", "SSC-H", pA = 2, pB = 3, 
    pC = -10, transformationId = "myRatioT")
transOut <- eval(myRatioT)(exprs(myDataIn))

}
\references{
Gating-ML 2.0: International Society for Advancement of
Cytometry (ISAC) standard for representing gating descriptions in flow
cytometry. \url{http://flowcyt.sourceforge.net/gating/20141009.pdf}
}
\seealso{
\code{\link{ratio}}, \code{\link{transform-class}},
\code{\link{transform}}

Other mathematical transform classes: 
\code{\link{EHtrans-class}},
\code{\link{asinht-class}},
\code{\link{asinhtGml2-class}},
\code{\link{dg1polynomial-class}},
\code{\link{exponential-class}},
\code{\link{hyperlog-class}},
\code{\link{hyperlogtGml2-class}},
\code{\link{invsplitscale-class}},
\code{\link{lintGml2-class}},
\code{\link{logarithm-class}},
\code{\link{logicletGml2-class}},
\code{\link{logtGml2-class}},
\code{\link{quadratic-class}},
\code{\link{ratio-class}},
\code{\link{sinht-class}},
\code{\link{splitscale-class}},
\code{\link{squareroot-class}},
\code{\link{unitytransform-class}}
}
\author{
Spidlen, J.
}
\concept{mathematical transform classes}
\keyword{classes}
