/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.vcf;

import com.gkano.bioinfo.var.Logger;
import com.gkano.bioinfo.vcf.SNPEncoder;
import com.gkano.bioinfo.vcf.VCFDecoder;
import com.gkano.bioinfo.vcf.VCFStreamingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class VCFManager<T>
implements Runnable {
    private final List<T> POISON_PILL_BATCH = Collections.emptyList();
    private final int batchSize = 1000;
    private final List<String> inputFileNames;
    private int usingThreads;
    private final int maxSizeOfVariantCache;
    private final Function<String, T> variantParser;
    private boolean verbose = false;
    private BlockingQueue<List<T>> variantRawCache;
    private Map<String, int[]> genotypeEncodingCache;
    private List<String> commentData;
    private String headerData;
    private static AtomicInteger currVariantCount;
    private int numVariants;
    private int numSamples;
    private List<String> sampleNames;
    private int ploidy;
    private int maxAlleles;
    private CountDownLatch startSignal;
    private CountDownLatch doneSignal;
    private ExecutorService pool;
    private List<CompletableFuture<ProcessorResult>> variantProcessors;
    private int numBootstraps = 0;

    public VCFManager(List<String> inputFileNames, int usingThreads, Function<String, T> variantParser, boolean verbose) {
        this.inputFileNames = inputFileNames;
        this.usingThreads = usingThreads;
        this.variantParser = variantParser;
        this.verbose = verbose;
        this.maxSizeOfVariantCache = 2 * usingThreads;
    }

    public void init() {
        if (this.inputFileNames == null || this.inputFileNames.isEmpty()) {
            Logger.error(this, "No VCF input files provided.");
            System.exit(1);
            return;
        }
        this.variantRawCache = new LinkedBlockingQueue<List<T>>(this.maxSizeOfVariantCache);
        this.genotypeEncodingCache = new ConcurrentHashMap<String, int[]>();
        this.commentData = new ArrayList<String>();
        currVariantCount = new AtomicInteger(0);
        int cpus = Runtime.getRuntime().availableProcessors();
        int n = this.usingThreads = cpus < this.usingThreads ? cpus : this.usingThreads;
        if (this.verbose) {
            Logger.info(this, "cpus=" + cpus + "\tusing=" + this.usingThreads);
        }
        this.startSignal = new CountDownLatch(1);
        this.doneSignal = new CountDownLatch(1);
        this.pool = Executors.newFixedThreadPool(this.usingThreads);
        this.variantProcessors = new ArrayList<CompletableFuture<ProcessorResult>>();
        for (int t = 0; t < this.usingThreads; ++t) {
            CompletableFuture<ProcessorResult> variantProcessor = CompletableFuture.supplyAsync(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }, this.pool);
            this.variantProcessors.add(variantProcessor);
        }
    }

    public void awaitFinalization() throws InterruptedException {
        this.doneSignal.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Logger.setVerbose(this.verbose);
            Logger.info(this, "START READ");
            VCFDecoder decoder = new VCFDecoder();
            ArrayList batch = new ArrayList(1000);
            VCFStreamingIterator<String> iterator = new VCFStreamingIterator<String>(decoder, this.verbose, this.inputFileNames);
            for (String line : iterator) {
                if (line == null) continue;
                this.processVariantLine(line, batch);
            }
            if (!batch.isEmpty()) {
                this.variantRawCache.put(batch);
            }
            for (int i = 0; i < this.usingThreads; ++i) {
                this.variantRawCache.put(this.POISON_PILL_BATCH);
            }
            Logger.info(this, "END READ");
            this.pool.shutdown();
            this.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            this.numVariants = currVariantCount.get();
            if (this.verbose) {
                Logger.info(this, "Processed variants :\t" + this.numVariants);
            }
            this.doneSignal.countDown();
        }
        catch (InterruptedException e) {
            Logger.error(this, e.getMessage());
            this.shutdown();
            System.exit(1);
        }
        finally {
            this.shutdown();
        }
    }

    private void processVariantLine(String line, List<T> batch) {
        block10: {
            try {
                if (line.startsWith("##")) {
                    this.commentData.add(line);
                    break block10;
                }
                if (line.startsWith("#")) {
                    this.headerData = line;
                    this.sampleNames = this.getSampleNamesFromHeader();
                    if (this.sampleNames == null || this.sampleNames.size() <= 0) {
                        this.shutdown();
                        System.exit(1);
                        return;
                    }
                    this.numSamples = this.sampleNames.size();
                    break block10;
                }
                if (this.ploidy <= 0) {
                    try {
                        int[] ploidy_maxAlleles = SNPEncoder.guessPloidyAndMaxAllele(line);
                        this.ploidy = ploidy_maxAlleles[0];
                        this.maxAlleles = ploidy_maxAlleles[1];
                        if (this.ploidy > 0) {
                            this.startSignal.countDown();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Logger.error(this, e.getMessage());
                        this.shutdown();
                        System.exit(1);
                        return;
                    }
                }
                T parsed = this.variantParser.apply(line);
                batch.add(parsed);
                if (batch.size() >= 1000) {
                    this.variantRawCache.put(new ArrayList<T>(batch));
                    batch.clear();
                }
            }
            catch (InterruptedException e) {
                Logger.error(this, e.getMessage());
            }
        }
    }

    public float[][] reduceDotProdToDistances() {
        int[][] finalDotProd = new int[this.numSamples][this.numSamples];
        int[] finalNorm = new int[this.numSamples];
        for (CompletableFuture<ProcessorResult> vp : this.variantProcessors) {
            ProcessorResult r = vp.join();
            for (int i = 0; i < this.numSamples; ++i) {
                int n = i;
                finalNorm[n] = finalNorm[n] + r.norm[0][i];
                for (int j = i; j < this.numSamples; ++j) {
                    int[] nArray = finalDotProd[i];
                    int n2 = j;
                    nArray[n2] = nArray[n2] + r.dotProd[0][i][j];
                }
            }
        }
        float[][] cosineDist = new float[this.numSamples][this.numSamples];
        for (int i = 0; i < this.numSamples; ++i) {
            float normI = (float)Math.sqrt(finalNorm[i]);
            for (int j = i; j < this.numSamples; ++j) {
                float dist;
                float similarity;
                float normJ = (float)Math.sqrt(finalNorm[j]);
                float dot = finalDotProd[i][j];
                float f = similarity = normI > 0.0f && normJ > 0.0f ? dot / (normI * normJ) : 0.0f;
                if (j == i && normI == 0.0f && normJ == 0.0f) {
                    similarity = 1.0f;
                }
                if ((dist = 1.0f - similarity) < 0.0f) {
                    dist = 0.0f;
                }
                float f2 = dist;
                cosineDist[j][i] = f2;
                cosineDist[i][j] = f2;
            }
        }
        return cosineDist;
    }

    public List<float[][]> reduceDotProdToDistancesBootstraps() {
        int j;
        int numReplicates = this.numBootstraps > 0 ? this.numBootstraps + 1 : 1;
        int[][][] finalDotProd = new int[numReplicates][this.numSamples][this.numSamples];
        int[][] finalNorm = new int[numReplicates][this.numSamples];
        for (CompletableFuture<ProcessorResult> vp : this.variantProcessors) {
            ProcessorResult r = vp.join();
            for (int rep = 0; rep < numReplicates; ++rep) {
                for (int i = 0; i < this.numSamples; ++i) {
                    int[] nArray = finalNorm[rep];
                    int n = i;
                    nArray[n] = nArray[n] + r.norm[rep][i];
                    for (j = i; j < this.numSamples; ++j) {
                        int[] nArray2 = finalDotProd[rep][i];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + r.dotProd[rep][i][j];
                    }
                }
            }
        }
        ArrayList<float[][]> allDistances = new ArrayList<float[][]>();
        for (int rep = 0; rep < numReplicates; ++rep) {
            float[][] cosineDist = new float[this.numSamples][this.numSamples];
            for (int i = 0; i < this.numSamples; ++i) {
                float normI = (float)Math.sqrt(finalNorm[rep][i]);
                for (j = i; j < this.numSamples; ++j) {
                    float dist;
                    float similarity;
                    float normJ = (float)Math.sqrt(finalNorm[rep][j]);
                    float dot = finalDotProd[rep][i][j];
                    float f = similarity = normI > 0.0f && normJ > 0.0f ? dot / (normI * normJ) : 0.0f;
                    if (j == i && normI == 0.0f && normJ == 0.0f) {
                        similarity = 1.0f;
                    }
                    if ((dist = 1.0f - similarity) < 0.0f) {
                        dist = 0.0f;
                    }
                    float f2 = dist;
                    cosineDist[j][i] = f2;
                    cosineDist[i][j] = f2;
                }
            }
            allDistances.add(cosineDist);
        }
        return allDistances;
    }

    public List<String> getSampleNamesFromHeader() {
        if (this.headerData == null || !this.headerData.startsWith("#CHROM")) {
            throw new IllegalArgumentException("Line does not start with #CHROM: " + this.headerData);
        }
        String[] fields = this.headerData.split("\t", -1);
        if (fields.length <= 9) {
            return Collections.emptyList();
        }
        return Arrays.asList(Arrays.copyOfRange(fields, 9, fields.length));
    }

    private void shutdown() {
        this.pool.shutdown();
    }

    public List<String> getSampleNames() {
        return this.sampleNames;
    }

    public int getNumVariants() {
        return this.numVariants;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getPloidy() {
        return this.ploidy;
    }

    public int getMaxAlleles() {
        return this.maxAlleles;
    }

    private static int poisson1(Random rand) {
        double L = Math.exp(-1.0);
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= rand.nextDouble()) > L);
        return k - 1;
    }

    public static class ProcessorResult {
        int[][][] dotProd;
        int[][] norm;
        int numReplicates;

        private ProcessorResult(int numReplicates, int numSamples) {
            this.numReplicates = numReplicates;
            this.dotProd = new int[numReplicates][numSamples][numSamples];
            this.norm = new int[numReplicates][numSamples];
        }

        public void merge(ProcessorResult other) {
            for (int r = 0; r < this.numReplicates; ++r) {
                for (int i = 0; i < this.norm[r].length; ++i) {
                    int[] nArray = this.norm[r];
                    int n = i;
                    nArray[n] = nArray[n] + other.norm[r][i];
                    for (int j = i; j < this.norm[r].length; ++j) {
                        int[] nArray2 = this.dotProd[r][i];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + other.dotProd[r][i][j];
                    }
                }
            }
        }
    }
}

