% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ex_datasets}
\alias{ex_datasets}
\alias{ex_trans}
\alias{ex_genes}
\alias{ex_prom}
\alias{ex_hic}
\title{Datasets for an example region}
\format{
GRanges and GInteractions objects

All annotations are from GRCh37

An object of class \code{GRanges} of length 4.

An object of class \code{GRanges} of length 9.

An object of class \code{GInteractions} of length 1.
}
\usage{
data(ex_trans)

data(ex_genes)

data(ex_prom)

data(ex_hic)
}
\description{
Various example datasets for demonstrating analysis and
visualisation strategies.
Generation of all datasets is documented in
\code{system.file("script/ex_datasets.md", package = "extraChIPs")}

\describe{
\item{ex_genes}{Simple GRanges object with complete ranges for each gene}
\item{ex_trans}{Exon & transcript level information prepared for plotting
with \code{Gviz} or \code{plotHFGC()}}
\item{ex_prom}{Regions defined as promoters}
\item{ex_hic}{Example HiC interactions}
}
}
\examples{
data(ex_trans)
ex_trans
}
\keyword{datasets}
