% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaEnrichment.R
\name{pcaEnrichment}
\alias{pcaEnrichment}
\title{Visualize the PCA of Enrichment Values}
\usage{
pcaEnrichment(
  input.data,
  dimRed = NULL,
  x.axis = "PC1",
  y.axis = "PC2",
  facet.by = NULL,
  style = c("point", "hex"),
  add.percent.contribution = TRUE,
  display.factors = FALSE,
  number.of.factors = 10,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Single‑cell object (Seurat / SCE) **or** the raw list
returned by [`performPCA()`].}

\item{dimRed}{Name of the dimensional‑reduction slot to pull from a
single‑cell object. Ignored when `input.data` is the list output.}

\item{x.axis, y.axis}{Character vectors naming the PCs to display (e.g. "PC1").}

\item{facet.by}{Metadata column to facet plot.}

\item{style}{"point" (default) or "hex".}

\item{add.percent.contribution}{Include percent variance explained in axis 
labels.}

\item{display.factors}{Draw arrows for the top gene‑set loadings.}

\item{number.of.factors}{Integer; how many loadings to display if
`display.factors = TRUE`.}

\item{palette}{Character. Any palette from \code{\link[grDevices]{hcl.pals}}.

#' @examples 
GS <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
pbmc_small <- SeuratObject::pbmc_small
pbmc_small <- runEscape(pbmc_small, 
                        gene.sets = GS, 
                        min.size = NULL)
                        
pbmc_small <- performPCA(pbmc_small, 
                         assay = "escape")
                         
pcaEnrichment(pbmc_small,
              x.axis = "PC1",
              y.axis = "PC2",
              dimRed = "escape.PCA")}
}
\value{
A **ggplot2** object.
}
\description{
This function allows to the user to examine the distribution
of principal components run on the enrichment values.
}
