% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapEnrichment.R
\name{heatmapEnrichment}
\alias{heatmapEnrichment}
\title{Visualize Enrichment Value Summaries Using Heatmaps}
\usage{
heatmapEnrichment(
  input.data,
  assay = NULL,
  group.by = NULL,
  gene.set.use = "all",
  cluster.rows = FALSE,
  cluster.columns = FALSE,
  facet.by = NULL,
  scale = FALSE,
  summary.stat = "mean",
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single‑cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Name of the assay holding enrichment scores when
`input.data` is a single‑cell object. Ignored otherwise.}

\item{group.by}{Metadata column plotted on the *x*‑axis.  Defaults to the
Seurat/SCE `ident` slot when `NULL`.}

\item{gene.set.use}{Vector of gene‑set names to plot, or \code{"all"}
(default) to show every available gene set.}

\item{cluster.rows, cluster.columns}{Logical; if \code{TRUE}, rows/columns
are ordered by Ward‑linkage hierarchical clustering (Euclidean distance).}

\item{facet.by}{Optional metadata column used to facet the plot.}

\item{scale}{If \code{TRUE}, Z‑transforms each gene‑set column **after**
summarization.}

\item{summary.stat}{Optional method used to summarize expression within each
group. One of: \code{"mean"} (default), \code{"median"}, \code{"max"}, 
\code{"sum"}, or \code{"geometric"}.}

\item{palette}{Character. Any palette from \code{\link[grDevices]{hcl.pals}}.}
}
\value{
A \code{ggplot2} object.
}
\description{
This function allows to the user to examine the heatmap with the mean
enrichment values by group. The heatmap will have the gene sets as rows
and columns will be the grouping variable.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)
  
heatmapEnrichment(pbmc, assay = "escape", palette = "viridis")

}
