% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeneSets.R
\name{getGeneSets}
\alias{getGeneSets}
\title{Get a collection of gene sets from the msigdb}
\usage{
getGeneSets(
  species = c("Homo sapiens", "Mus musculus"),
  library = NULL,
  subcategory = NULL,
  gene.sets = NULL,
  version = "7.4",
  id = "SYM"
)
}
\arguments{
\item{species}{`"Homo sapiens"` (default) or `"Mus musculus"`.}

\item{library}{Character. Optional vector of main collection codes 
(e.g. `"H"`, `"C5"`).}

\item{subcategory}{Character. Optional vector of sub-collection codes 
(e.g. `"GO:BP"`).}

\item{gene.sets}{Character. Optional vector of specific gene-set names.}

\item{version}{MSigDB version (character, default `"7.4"`).}

\item{id}{Identifier type (default `"SYM"` for symbols).}
}
\value{
A named `list` of character vectors (gene IDs).
}
\description{
This function retrieves gene sets from msigdb and caches the downloaded object 
for future calls. It allows subsetting by main collection (library), 
subcollection, or specific gene sets, and only supports human 
("Homo sapiens") and mouse ("Mus musculus").
}
\examples{
\dontrun{
# Get all hallmark gene sets from human.
gs <- getGeneSets(species = "Homo sapiens", 
                  library = "H")

# Get a subset based on main collection and subcollection.
gs <- getGeneSets(species = "Homo sapiens", 
                  library = c("C2", "C5"), 
                  subcategory = "GO:BP")
}

}
