% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichDAVID.R
\name{enrichDAVID}
\alias{enrichDAVID}
\title{enrichDAVID}
\usage{
enrichDAVID(
  gene,
  idType = "ENTREZ_GENE_ID",
  universe,
  minGSSize = 10,
  maxGSSize = 500,
  annotation = "GOTERM_BP_FAT",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  qvalueCutoff = 0.2,
  species = NA,
  david.user
)
}
\arguments{
\item{gene}{input gene}

\item{idType}{id type}

\item{universe}{background genes. If missing, the all genes listed in the database (eg TERM2GENE table) will be used as background.}

\item{minGSSize}{minimal size of genes annotated for testing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{annotation}{david annotation}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report as significant.  Tests must pass i) \code{pvalueCutoff} on unadjusted pvalues, ii) \code{pvalueCutoff} on adjusted pvalues and iii) \code{qvalueCutoff} on qvalues to be reported.}

\item{species}{species}

\item{david.user}{david user}
}
\value{
A \code{enrichResult} instance
}
\description{
enrichment analysis by DAVID
}
\author{
Guangchuang Yu
}
